/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.datanucleus;

import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.integration.datanucleus.DataNucleusJpaMetamodelAccessor;
import com.blazebit.persistence.spi.JoinTable;
import com.blazebit.persistence.spi.JpaMetamodelAccessor;
import com.blazebit.persistence.spi.JpaProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.jpa.metamodel.AttributeImpl;
import org.datanucleus.api.jpa.metamodel.EntityTypeImpl;
import org.datanucleus.api.jpa.metamodel.ManagedTypeImpl;
import org.datanucleus.identity.SingleFieldId;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.KeyMetaData;

public class DataNucleusJpaProvider
implements JpaProvider {
    private static final String[] EMPTY = new String[0];
    private final PersistenceUnitUtil persistenceUnitUtil;
    private final int major;
    private final int minor;
    private final int fix;

    public DataNucleusJpaProvider(PersistenceUnitUtil persistenceUnitUtil, int major, int minor, int fix) {
        this.persistenceUnitUtil = persistenceUnitUtil;
        this.major = major;
        this.minor = minor;
        this.fix = fix;
    }

    public boolean supportsJpa21() {
        return true;
    }

    public boolean supportsEntityJoin() {
        return this.major >= 5;
    }

    public boolean supportsCrossJoin() {
        return false;
    }

    public boolean supportsInsertStatement() {
        return false;
    }

    public boolean needsBracketsForListParameter() {
        return true;
    }

    public boolean needsJoinSubqueryRewrite() {
        return false;
    }

    public String getBooleanExpression(boolean value) {
        return value ? "TRUE" : "FALSE";
    }

    public String getBooleanConditionalExpression(boolean value) {
        return value ? "TRUE" : "FALSE";
    }

    public String getNullExpression() {
        return "NULL";
    }

    public String escapeCharacter(char character) {
        return Character.toString(character);
    }

    public boolean supportsNullPrecedenceExpression() {
        return true;
    }

    public void renderNullPrecedence(StringBuilder sb, String expression, String resolvedExpression, String order, String nulls) {
        sb.append(expression);
        if (order != null) {
            sb.append(' ').append(order);
            if (nulls != null) {
                sb.append(" NULLS ").append(nulls);
            }
        }
    }

    public String getOnClause() {
        return "ON";
    }

    public String getCollectionValueFunction() {
        return "VALUE";
    }

    public boolean supportsCollectionValueDereference() {
        return true;
    }

    public boolean supportsSubqueryLimitOffset() {
        return false;
    }

    public boolean supportsSetOperations() {
        return false;
    }

    public boolean supportsListagg() {
        return false;
    }

    public Class<?> getDefaultQueryResultType() {
        return null;
    }

    public String getCustomFunctionInvocation(String functionName, int argumentCount) {
        return functionName + "(";
    }

    public boolean supportsRootTreat() {
        return true;
    }

    public boolean supportsTreatJoin() {
        return this.major >= 5;
    }

    public boolean supportsTreatCorrelation() {
        return false;
    }

    public boolean supportsRootTreatJoin() {
        return false;
    }

    public boolean supportsRootTreatTreatJoin() {
        return false;
    }

    public boolean supportsSubtypePropertyResolving() {
        return false;
    }

    public boolean supportsSubtypeRelationResolving() {
        return true;
    }

    public boolean supportsCountStar() {
        return false;
    }

    public boolean supportsCountTuple() {
        return false;
    }

    public boolean supportsCustomFunctions() {
        return true;
    }

    public boolean supportsNonScalarSubquery() {
        return true;
    }

    public boolean supportsSubqueryInFunction() {
        return true;
    }

    public boolean supportsSubqueryAliasShadowing() {
        return false;
    }

    public String[] getDiscriminatorColumnCheck(EntityType<?> entityType) {
        return null;
    }

    public boolean isForeignJoinColumn(EntityType<?> ownerType, String attributeName) {
        ManagedTypeImpl managedType = (ManagedTypeImpl)ownerType;
        String[] parts = attributeName.split("\\.");
        AbstractMemberMetaData metaData = managedType.getMetadata().getMetaDataForMember(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            EmbeddedMetaData embeddedMetaData = metaData.getEmbeddedMetaData();
            if (embeddedMetaData == null) {
                return metaData.getJoinMetaData() != null;
            }
            AbstractMemberMetaData[] metaDatas = embeddedMetaData.getMemberMetaData();
            metaData = null;
            for (int j = 0; j < metaDatas.length; ++j) {
                if (!parts[i].equals(metaDatas[j].getName())) continue;
                metaData = metaDatas[j];
                break;
            }
            if (metaData != null) continue;
            throw new IllegalArgumentException("Could not find property '" + parts[i] + "' in embeddable type: " + ((AbstractMemberMetaData)embeddedMetaData.getParent()).getType().getName());
        }
        return metaData.getJoinMetaData() != null;
    }

    public boolean isColumnShared(EntityType<?> ownerType, String attributeName) {
        return false;
    }

    public JpaProvider.ConstraintType requiresTreatFilter(EntityType<?> ownerType, String attributeName, JoinType joinType) {
        return JpaProvider.ConstraintType.NONE;
    }

    public String getMappedBy(EntityType<?> ownerType, String attributeName) {
        AbstractMemberMetaData metaData = this.getAttribute((ManagedType<?>)ownerType, attributeName).getMetadata();
        return metaData.getMappedBy();
    }

    public Map<String, String> getWritableMappedByMappings(EntityType<?> inverseType, EntityType<?> ownerType, String attributeName, String inverseAttribute) {
        return null;
    }

    public String[] getColumnNames(EntityType<?> ownerType, String attributeName) {
        return EMPTY;
    }

    public String[] getColumnNames(EntityType<?> ownerType, String elementCollectionPath, String attributeName) {
        return EMPTY;
    }

    public String[] getColumnTypes(EntityType<?> ownerType, String attributeName) {
        return EMPTY;
    }

    public String[] getColumnTypes(EntityType<?> ownerType, String elementCollectionPath, String attributeName) {
        return EMPTY;
    }

    private AttributeImpl<?, ?> getAttribute(ManagedType<?> ownerType, String attributeName) {
        if (attributeName.indexOf(46) == -1) {
            return (AttributeImpl)ownerType.getAttribute(attributeName);
        }
        ManagedType t = ownerType;
        Attribute attr = null;
        String[] parts = attributeName.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            attr = t.getAttribute(parts[i]);
            Type type = attr instanceof PluralAttribute ? ((PluralAttribute)attr).getElementType() : ((SingularAttribute)attr).getType();
            if (type.getPersistenceType() != Type.PersistenceType.BASIC) {
                t = (ManagedType)type;
                continue;
            }
            if (i + 1 == parts.length) continue;
            throw new IllegalArgumentException("Illegal attribute name for type [" + ownerType.getJavaType().getName() + "]: " + attributeName);
        }
        return (AttributeImpl)attr;
    }

    public JoinTable getJoinTable(EntityType<?> ownerType, String attributeName) {
        AttributeImpl<?, ?> attribute = this.getAttribute((ManagedType<?>)ownerType, attributeName);
        AbstractMemberMetaData metaData = attribute.getMetadata();
        if (metaData.getJoinMetaData() != null) {
            Map<String, String> targetIdColumnMapping;
            Map<String, String> idColumnMapping;
            String tableName;
            String columnName;
            Map<Object, Object> keyMapping = null;
            Map keyColumnTypes = null;
            KeyMetaData keyMetaData = metaData.getKeyMetaData();
            if (keyMetaData != null && keyMetaData.getColumnMetaData() != null) {
                ColumnMetaData[] keyTargetPrimaryKeyColumnMetaData;
                keyMapping = new LinkedHashMap();
                ColumnMetaData[] keyColumnMetaData = keyMetaData.getColumnMetaData();
                ColumnMetaData[] columnMetaDataArray = keyTargetPrimaryKeyColumnMetaData = keyMetaData.getForeignKeyMetaData() == null ? null : keyMetaData.getForeignKeyMetaData().getColumnMetaData();
                if (keyTargetPrimaryKeyColumnMetaData == null) {
                    keyMapping.put(keyMetaData.getColumnName(), keyMetaData.getColumnName());
                } else {
                    for (int i = 0; i < keyTargetPrimaryKeyColumnMetaData.length; ++i) {
                        keyMapping.put(keyColumnMetaData[i].getName(), keyTargetPrimaryKeyColumnMetaData[i].getName());
                    }
                }
            } else if (metaData.getOrderMetaData() != null && (columnName = metaData.getOrderMetaData().getColumnName()) != null) {
                keyMapping = Collections.singletonMap(columnName, columnName);
            }
            if (metaData.getJoinMetaData().getTable() == null) {
                ColumnMetaData[] elementMetaData;
                int i;
                ColumnMetaData[] joinMetaData;
                tableName = metaData.getTable();
                if (metaData.getJoinMetaData() == null || (joinMetaData = metaData.getJoinMetaData().getColumnMetaData()) == null) {
                    idColumnMapping = Collections.emptyMap();
                } else {
                    idColumnMapping = new LinkedHashMap(joinMetaData.length);
                    for (i = 0; i < joinMetaData.length; ++i) {
                        idColumnMapping.put(joinMetaData[i].getName(), joinMetaData[i].getTarget());
                    }
                }
                if (metaData.getElementMetaData() == null || (elementMetaData = metaData.getElementMetaData().getColumnMetaData()) == null) {
                    targetIdColumnMapping = Collections.emptyMap();
                } else {
                    targetIdColumnMapping = new LinkedHashMap(elementMetaData.length);
                    for (i = 0; i < elementMetaData.length; ++i) {
                        targetIdColumnMapping.put(elementMetaData[i].getName(), elementMetaData[i].getTarget());
                    }
                }
            } else {
                tableName = metaData.getJoinMetaData().getTable();
                ColumnMetaData[] primaryKeyColumnMetaData = metaData.getJoinMetaData().getPrimaryKeyMetaData().getColumnMetaData();
                ColumnMetaData[] foreignKeyColumnMetaData = metaData.getJoinMetaData().getForeignKeyMetaData().getColumnMetaData();
                idColumnMapping = new LinkedHashMap(primaryKeyColumnMetaData.length);
                for (int i = 0; i < foreignKeyColumnMetaData.length; ++i) {
                    idColumnMapping.put(foreignKeyColumnMetaData[i].getName(), primaryKeyColumnMetaData[i].getName());
                }
                ColumnMetaData[] targetColumnMetaData = metaData.getJoinMetaData().getColumnMetaData();
                ColumnMetaData[] targetPrimaryKeyColumnMetaData = metaData.getElementMetaData().getForeignKeyMetaData().getColumnMetaData();
                targetIdColumnMapping = new LinkedHashMap(targetPrimaryKeyColumnMetaData.length);
                for (int i = 0; i < targetColumnMetaData.length; ++i) {
                    targetIdColumnMapping.put(targetColumnMetaData[i].getName(), targetPrimaryKeyColumnMetaData[i].getName());
                }
            }
            return new JoinTable(tableName, null, idColumnMapping, keyMapping, keyColumnTypes, null, targetIdColumnMapping);
        }
        return null;
    }

    public boolean isBag(EntityType<?> ownerType, String attributeName) {
        AttributeImpl<?, ?> attribute = this.getAttribute((ManagedType<?>)ownerType, attributeName);
        if (attribute instanceof PluralAttribute) {
            PluralAttribute pluralAttr = (PluralAttribute)attribute;
            if (pluralAttr.getCollectionType() == PluralAttribute.CollectionType.COLLECTION) {
                return true;
            }
            if (pluralAttr.getCollectionType() == PluralAttribute.CollectionType.LIST) {
                AbstractMemberMetaData metaData = attribute.getMetadata();
                return metaData.getOrderMetaData() == null;
            }
        }
        return false;
    }

    public boolean isOrphanRemoval(ManagedType<?> ownerType, String attributeName) {
        AttributeImpl<?, ?> attribute = this.getAttribute(ownerType, attributeName);
        return attribute != null && attribute.getMetadata().isCascadeRemoveOrphans();
    }

    public boolean isOrphanRemoval(ManagedType<?> ownerType, String elementCollectionPath, String attributeName) {
        return false;
    }

    public boolean isDeleteCascaded(ManagedType<?> ownerType, String attributeName) {
        AttributeImpl<?, ?> attribute = this.getAttribute(ownerType, attributeName);
        return attribute != null && attribute.getMetadata().isCascadeDelete();
    }

    public boolean isDeleteCascaded(ManagedType<?> ownerType, String elementCollectionPath, String attributeName) {
        return false;
    }

    public boolean hasJoinCondition(ManagedType<?> ownerType, String elementCollectionPath, String attributeName) {
        return false;
    }

    public boolean containsEntity(EntityManager em, Class<?> entityClass, Object id) {
        ExecutionContext ec = (ExecutionContext)em.unwrap(ExecutionContext.class);
        return ec.getAttachedObjectForId(ec.newObjectId(entityClass, id)) != null;
    }

    public boolean supportsSingleValuedAssociationIdExpressions() {
        return false;
    }

    public boolean supportsForeignAssociationInOnClause() {
        return true;
    }

    public boolean supportsUpdateSetEmbeddable() {
        return true;
    }

    public boolean supportsUpdateSetAssociationId() {
        return true;
    }

    public boolean supportsTransientEntityAsParameter() {
        return false;
    }

    public boolean needsAssociationToIdRewriteInOnClause() {
        return false;
    }

    public boolean needsBrokenAssociationToIdRewriteInOnClause() {
        return false;
    }

    public boolean needsTypeConstraintForColumnSharing() {
        return false;
    }

    public boolean supportsCollectionTableCleanupOnDelete() {
        return false;
    }

    public boolean supportsJoinTableCleanupOnDelete() {
        return false;
    }

    public boolean needsCorrelationPredicateWhenCorrelatingWithWhereClause() {
        return false;
    }

    public boolean supportsSingleValuedAssociationNaturalIdExpressions() {
        return false;
    }

    public boolean supportsGroupByEntityAlias() {
        return true;
    }

    public boolean needsElementCollectionIdCutoff() {
        return false;
    }

    public boolean needsUnproxyForFieldAccess() {
        return false;
    }

    public boolean needsCaseWhenElseBranch() {
        return false;
    }

    public boolean supportsLikePatternEscape() {
        return true;
    }

    public void setCacheable(Query query) {
        query.setHint("datanucleus.query.results.cached", (Object)true);
    }

    public void setSingularParameter(Query query, String name, Object value) {
        query.setParameter(name, value);
    }

    public List<String> getIdentifierOrUniqueKeyEmbeddedPropertyNames(EntityType<?> ownerType, String attributeName) {
        AttributeImpl<?, ?> attribute = this.getAttribute((ManagedType<?>)ownerType, attributeName);
        if (attribute.getType() instanceof EntityType) {
            EntityTypeImpl entityType = (EntityTypeImpl)attribute.getType();
            if (entityType.hasSingleIdAttribute()) {
                return Collections.singletonList(entityType.getId(entityType.getIdType().getJavaType()).getName());
            }
            Set attributes = entityType.getIdClassAttributes();
            ArrayList<String> attributeNames = new ArrayList<String>(attributes.size());
            for (Attribute attr : attributes) {
                attributeNames.add(attr.getName());
            }
            return attributeNames;
        }
        return Collections.emptyList();
    }

    public List<String> getIdentifierOrUniqueKeyEmbeddedPropertyNames(EntityType<?> ownerType, String elementCollectionPath, String attributeName) {
        ManagedType t = ownerType;
        Attribute attr = null;
        String[] parts = attributeName.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            attr = t.getAttribute(parts[i]);
            if (attr instanceof SingularAttribute) {
                SingularAttribute singularAttribute = (SingularAttribute)attr;
                if (singularAttribute.getType().getPersistenceType() != Type.PersistenceType.BASIC) {
                    t = (ManagedType)singularAttribute.getType();
                    continue;
                }
                if (i + 1 == parts.length) continue;
                throw new IllegalArgumentException("Illegal attribute name for type [" + ownerType.getJavaType().getName() + "]: " + attributeName);
            }
            PluralAttribute pluralAttribute = (PluralAttribute)attr;
            if (pluralAttribute.getElementType().getPersistenceType() != Type.PersistenceType.BASIC) {
                t = (ManagedType)pluralAttribute.getElementType();
                continue;
            }
            if (i + 1 == parts.length) continue;
            throw new IllegalArgumentException("Illegal attribute name for type [" + ownerType.getJavaType().getName() + "]: " + attributeName);
        }
        ManagedType entityType = t;
        if (entityType.hasSingleIdAttribute()) {
            return Collections.singletonList(entityType.getId(entityType.getIdType().getJavaType()).getName());
        }
        Set attributes = entityType.getIdClassAttributes();
        ArrayList<String> attributeNames = new ArrayList<String>(attributes.size());
        for (Attribute attribute : attributes) {
            attributeNames.add(attribute.getName());
        }
        return attributeNames;
    }

    public Map<String, String> getJoinMappingPropertyNames(EntityType<?> owner, String elementCollectionPath, String attributeName) {
        List<String> keys = elementCollectionPath == null ? this.getIdentifierOrUniqueKeyEmbeddedPropertyNames(owner, attributeName) : this.getIdentifierOrUniqueKeyEmbeddedPropertyNames(owner, elementCollectionPath, attributeName);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(keys.size());
        for (String key : keys) {
            map.put(key, null);
        }
        return map;
    }

    public boolean supportsEnumLiteral(ManagedType<?> ownerType, String attributeName, boolean key) {
        return true;
    }

    public boolean supportsTemporalLiteral() {
        return true;
    }

    public boolean supportsNonDrivingAliasInOnClause() {
        return true;
    }

    public boolean supportsSelectCompositeIdEntityInSubquery() {
        return true;
    }

    public boolean supportsProxyParameterForNonPkAssociation() {
        return true;
    }

    public boolean supportsProxyRemove() {
        return false;
    }

    public void initialize(Object entity) {
        entity.hashCode();
    }

    public Object getIdentifier(Object entity) {
        Object identifier = this.persistenceUnitUtil.getIdentifier(entity);
        if (identifier instanceof SingleFieldId) {
            return ((SingleFieldId)identifier).getKeyAsObject();
        }
        return identifier;
    }

    public <T> T unproxy(T entity) {
        return entity;
    }

    public JpaMetamodelAccessor getJpaMetamodelAccessor() {
        return DataNucleusJpaMetamodelAccessor.INSTANCE;
    }
}

