/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.datanucleus.function;

import com.blazebit.persistence.integration.datanucleus.function.JpqlFunctionSQLMethod;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;
import java.sql.Date;
import java.util.logging.Logger;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.ByteExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.EnumExpression;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.rdbms.sql.method.SimpleOrderableAggregateMethod;

public abstract class AbstractJpqlFunctionSQLMethod
implements JpqlFunction {
    private static final Logger LOG = Logger.getLogger(JpqlFunctionSQLMethod.class.getName());
    protected final SQLStatement stmt;
    protected final SQLMethod function;

    public AbstractJpqlFunctionSQLMethod(SQLStatement stmt, SQLMethod function) {
        this.stmt = stmt;
        this.function = function;
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Class<?> getReturnType(Class<?> firstArgumentType) {
        TemporalExpression expression;
        if (firstArgumentType == null) {
            return null;
        }
        JavaTypeMapping argumentTypeMapping = this.stmt.getSQLExpressionFactory().getMappingForType(firstArgumentType, true);
        if (Date.class.isAssignableFrom(firstArgumentType)) {
            expression = new TemporalExpression(this.stmt, argumentTypeMapping, "", null);
        } else if (Byte.class.isAssignableFrom(firstArgumentType)) {
            expression = new ByteExpression(this.stmt, null, argumentTypeMapping);
        } else if (Number.class.isAssignableFrom(firstArgumentType)) {
            expression = new NumericExpression(this.stmt, argumentTypeMapping, "");
        } else if (String.class.isAssignableFrom(firstArgumentType)) {
            expression = new StringExpression(this.stmt, null, argumentTypeMapping);
        } else if (Character.class.isAssignableFrom(firstArgumentType)) {
            expression = new CharacterExpression(this.stmt, null, argumentTypeMapping);
        } else if (Boolean.class.isAssignableFrom(firstArgumentType)) {
            expression = new BooleanExpression(this.stmt, argumentTypeMapping, "");
        } else if (firstArgumentType.isEnum()) {
            if (this.function instanceof SimpleOrderableAggregateMethod) {
                return firstArgumentType;
            }
            expression = new EnumExpression(this.stmt, null, argumentTypeMapping);
        } else {
            throw new UnsupportedOperationException("Unsupported data type: " + firstArgumentType.getName());
        }
        this.function.setStatement(this.stmt);
        SQLExpression resultExpression = this.getExpression((SQLExpression)expression);
        return resultExpression.getJavaTypeMapping().getJavaType();
    }

    protected abstract SQLExpression getExpression(SQLExpression var1);

    public void render(FunctionRenderContext context) {
        throw new UnsupportedOperationException("Rendering functions through this API is not possible!");
    }
}

