/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.datanucleus.function;

import com.blazebit.persistence.integration.datanucleus.DataNucleusJpaProvider;
import com.blazebit.persistence.integration.datanucleus.function.DataNucleusJpqlFunctionAdapter;
import com.blazebit.persistence.integration.datanucleus.function.JpqlFunctionInstanceSQLMethod;
import com.blazebit.persistence.integration.datanucleus.function.JpqlFunctionSQLMethod;
import com.blazebit.persistence.integration.datanucleus.function.QueryGeneratorInvocationHandler;
import com.blazebit.persistence.integration.jpa.function.CountStarFunction;
import com.blazebit.persistence.spi.EntityManagerFactoryIntegrator;
import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.spi.JpaProviderFactory;
import com.blazebit.persistence.spi.JpqlFunction;
import com.blazebit.persistence.spi.JpqlFunctionGroup;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnitUtil;
import org.datanucleus.NucleusContext;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.query.QueryGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.rdbms.table.Table;

public class DataNucleusEntityManagerFactoryIntegrator
implements EntityManagerFactoryIntegrator {
    public static final String VERSION;
    public static final int MAJOR;
    public static final int MINOR;
    public static final int FIX;
    private static final Logger LOG;
    private static final Map<String, String> VENDOR_TO_DBMS_MAPPING;

    public String getDbms(EntityManagerFactory entityManagerFactory) {
        String datastoreProductVersion;
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)entityManagerFactory.unwrap(StoreManager.class);
        DatastoreAdapter datastoreAdapter = storeMgr.getDatastoreAdapter();
        String vendorID = datastoreAdapter.getVendorID();
        if ("mysql".equals(vendorID) && Integer.parseInt((datastoreProductVersion = datastoreAdapter.getDatastoreProductVersion()).substring(0, datastoreProductVersion.indexOf(46))) > 7) {
            return "mysql8";
        }
        return VENDOR_TO_DBMS_MAPPING.get(vendorID);
    }

    public JpaProviderFactory getJpaProviderFactory(final EntityManagerFactory entityManagerFactory) {
        return new JpaProviderFactory(){

            public JpaProvider createJpaProvider(EntityManager em) {
                PersistenceUnitUtil persistenceUnitUtil;
                PersistenceUnitUtil persistenceUnitUtil2 = persistenceUnitUtil = entityManagerFactory == null ? null : entityManagerFactory.getPersistenceUnitUtil();
                if (persistenceUnitUtil == null && em != null) {
                    persistenceUnitUtil = em.getEntityManagerFactory().getPersistenceUnitUtil();
                }
                return new DataNucleusJpaProvider(persistenceUnitUtil, MAJOR, MINOR, FIX);
            }
        };
    }

    public EntityManagerFactory registerFunctions(EntityManagerFactory entityManagerFactory, Map<String, JpqlFunctionGroup> dbmsFunctions) {
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)entityManagerFactory.unwrap(StoreManager.class);
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        String dbms = VENDOR_TO_DBMS_MAPPING.get(storeMgr.getDatastoreAdapter().getVendorID());
        if (!exprFactory.isMethodRegistered(null, "count_star")) {
            exprFactory.registerMethod(null, "count_star", (SQLMethod)new DataNucleusJpqlFunctionAdapter((JpqlFunction)new CountStarFunction(), true), true);
        }
        if (MAJOR < 5 && !(exprFactory.getMethod("java.util.Date", "getMonth", null) instanceof DataNucleusJpqlFunctionAdapter)) {
            LOG.warning("Overriding DataNucleus native 'MONTH' function to return months 1-based like ANSI EXTRACT instead of 0-based!");
            JpqlFunctionGroup dbmsFunctionGroup = dbmsFunctions.get("month");
            JpqlFunction function = dbmsFunctionGroup.get(dbms);
            if (function == null && !dbmsFunctionGroup.contains(dbms)) {
                function = dbmsFunctionGroup.get(null);
            }
            DataNucleusJpqlFunctionAdapter method = new DataNucleusJpqlFunctionAdapter(function, dbmsFunctionGroup.isAggregate());
            Set set = (Set)this.fieldGet("methodNamesSupported", exprFactory, VERSION);
            for (Object methodKey : set) {
                if (!"getMonth".equals((String)this.fieldGet("methodName", methodKey, VERSION)) || !"java.util.Date".equals((String)this.fieldGet("clsName", methodKey, VERSION))) continue;
                ((Map)this.fieldGet("methodByClassMethodName", exprFactory, VERSION)).put(methodKey, method);
            }
        }
        Map<String, JpqlFunction> registeredFunctions = this.getRegisteredFunctions(entityManagerFactory);
        HashMap<String, String> caseInsensitiveRegisteredFunctions = new HashMap<String, String>(registeredFunctions.size());
        for (String string : registeredFunctions.keySet()) {
            caseInsensitiveRegisteredFunctions.put(string.toLowerCase(), string);
        }
        for (Map.Entry entry : dbmsFunctions.entrySet()) {
            String functionName = (String)entry.getKey();
            JpqlFunctionGroup dbmsFunctionGroup = (JpqlFunctionGroup)entry.getValue();
            JpqlFunction function = dbmsFunctionGroup.get(dbms);
            if (function == null && !dbmsFunctionGroup.contains(dbms)) {
                function = dbmsFunctionGroup.get(null);
            }
            if (function == null) {
                LOG.warning("Could not register the function '" + functionName + "' because there is neither an implementation for the dbms '" + dbms + "' nor a default implementation!");
                continue;
            }
            if (caseInsensitiveRegisteredFunctions.containsKey(functionName.toLowerCase())) continue;
            exprFactory.registerMethod(null, functionName, (SQLMethod)new DataNucleusJpqlFunctionAdapter(function, dbmsFunctionGroup.isAggregate()), true);
        }
        return entityManagerFactory;
    }

    public Map<String, JpqlFunction> getRegisteredFunctions(EntityManagerFactory entityManagerFactory) {
        SQLStatement stmt;
        NucleusContext context = (NucleusContext)entityManagerFactory.unwrap(NucleusContext.class);
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)entityManagerFactory.unwrap(StoreManager.class);
        String storeName = storeMgr.getDatastoreAdapter().getVendorID();
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        Set methodKeys = (Set)this.fieldGet("methodNamesSupported", exprFactory, VERSION);
        if (methodKeys.isEmpty()) {
            return new HashMap<String, JpqlFunction>();
        }
        HashMap<String, JpqlFunction> functions = new HashMap<String, JpqlFunction>();
        Class[] parameterTypes = new Class[]{RDBMSStoreManager.class, Table.class, DatastoreIdentifier.class, String.class};
        try {
            Constructor<?> c = Class.forName("org.datanucleus.store.rdbms.sql.SelectStatement").getConstructor(parameterTypes);
            stmt = (SQLStatement)c.newInstance(storeMgr, null, null, null);
        }
        catch (Exception e) {
            try {
                Constructor<?> c = Class.forName("org.datanucleus.store.rdbms.sql.SQLStatement").getConstructor(parameterTypes);
                stmt = (SQLStatement)c.newInstance(storeMgr, null, null, null);
            }
            catch (Exception e2) {
                throw new RuntimeException("Could not access the required methods to dynamically retrieve registered functions. Please report this version of datanucleus(" + VERSION + ") so we can provide support for it!", e2);
            }
        }
        QueryGenerator noopGenerator = (QueryGenerator)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{QueryGenerator.class}, (InvocationHandler)new QueryGeneratorInvocationHandler(context));
        stmt.setQueryGenerator(noopGenerator);
        for (Object methodKey : methodKeys) {
            String className = (String)this.fieldGet("clsName", methodKey, VERSION);
            String datastoreName = (String)this.fieldGet("datastoreName", methodKey, VERSION);
            String name = (String)this.fieldGet("methodName", methodKey, VERSION);
            if (!className.isEmpty() || name.indexOf(46) != -1 || !"ALL".equals(datastoreName) && !storeName.equals(datastoreName)) continue;
            SQLMethod method = exprFactory.getMethod(null, name, Collections.emptyList());
            if (method instanceof DataNucleusJpqlFunctionAdapter) {
                functions.put(name, ((DataNucleusJpqlFunctionAdapter)method).unwrap());
                continue;
            }
            functions.put(name, new JpqlFunctionSQLMethod(stmt, method));
        }
        SQLMethod method = exprFactory.getMethod("java.lang.String", "length", Collections.emptyList());
        functions.put("length", new JpqlFunctionInstanceSQLMethod(stmt, method));
        return functions;
    }

    private static String readMavenPropertiesVersion(String name) {
        InputStream is = null;
        try {
            is = NucleusContext.class.getClassLoader().getResourceAsStream(name);
            Properties p = new Properties();
            p.load(is);
            String string = p.getProperty("version");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not access the maven version properties of datanucleus!", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T fieldGet(String fieldName, Object value, String version) {
        Exception ex;
        Field field = null;
        boolean madeAccessible = false;
        try {
            field = value.getClass().getDeclaredField(fieldName);
            boolean bl = madeAccessible = !field.isAccessible();
            if (madeAccessible) {
                field.setAccessible(true);
            }
            Object object = field.get(value);
            return (T)object;
        }
        catch (NoSuchFieldException e) {
            ex = e;
        }
        catch (SecurityException e) {
            ex = e;
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        finally {
            if (madeAccessible) {
                field.setAccessible(false);
            }
        }
        throw new RuntimeException("Could not access the required methods to dynamically retrieve registered functions. Please report this version of datanucleus(" + version + ") so we can provide support for it!", ex);
    }

    static {
        LOG = Logger.getLogger(DataNucleusEntityManagerFactoryIntegrator.class.getName());
        VENDOR_TO_DBMS_MAPPING = new HashMap<String, String>();
        VENDOR_TO_DBMS_MAPPING.put("h2", "h2");
        VENDOR_TO_DBMS_MAPPING.put("mysql", "mysql");
        VENDOR_TO_DBMS_MAPPING.put("db2", "db2");
        VENDOR_TO_DBMS_MAPPING.put("firebird", "firebird");
        VENDOR_TO_DBMS_MAPPING.put("postgresql", "postgresql");
        VENDOR_TO_DBMS_MAPPING.put("oracle", "oracle");
        VENDOR_TO_DBMS_MAPPING.put("sqlite", "sqlite");
        VENDOR_TO_DBMS_MAPPING.put("sqlserver", "microsoft");
        VENDOR_TO_DBMS_MAPPING.put("sybase", "sybase");
        VENDOR_TO_DBMS_MAPPING.put("hsql", "hsql");
        VENDOR_TO_DBMS_MAPPING.put("informix", "informix");
        VERSION = DataNucleusEntityManagerFactoryIntegrator.readMavenPropertiesVersion("META-INF/maven/org.datanucleus/datanucleus-core/pom.properties");
        String[] versionParts = VERSION.split("[\\.-]");
        MAJOR = Integer.parseInt(versionParts[0]);
        MINOR = Integer.parseInt(versionParts[1]);
        FIX = Integer.parseInt(versionParts[2]);
    }
}

