/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.datanucleus.function;

import com.blazebit.persistence.integration.datanucleus.function.CustomSQLText;
import com.blazebit.persistence.integration.datanucleus.function.DataNucleusFunctionRenderContext;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.TemporalMapping;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.expression.AggregateNumericExpression;
import org.datanucleus.store.rdbms.sql.expression.AggregateStringExpression;
import org.datanucleus.store.rdbms.sql.expression.AggregateTemporalExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.ByteExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;

public class DataNucleusJpqlFunctionAdapter
extends AbstractSQLMethod {
    private static final Logger LOG = Logger.getLogger(DataNucleusJpqlFunctionAdapter.class.getName());
    private final JpqlFunction function;
    private final boolean aggregate;

    public DataNucleusJpqlFunctionAdapter(JpqlFunction function, boolean aggregate) {
        this.function = function;
        this.aggregate = aggregate;
    }

    public JpqlFunction unwrap() {
        return this.function;
    }

    public SQLExpression getExpression(SQLExpression expr, List<SQLExpression> args) {
        Class returnType;
        JavaTypeMapping returnTypeMapping;
        int i;
        int argsSize = args.size();
        ArrayList<String> newArgs = new ArrayList<String>(argsSize + (expr == null ? 0 : 1));
        Class firstArgumentType = null;
        JavaTypeMapping firstArgumentTypeMapping = null;
        if (expr != null) {
            firstArgumentTypeMapping = expr.getJavaTypeMapping();
            firstArgumentType = firstArgumentTypeMapping.getJavaType();
            newArgs.add(expr.toSQLText().toSQL());
            for (i = 0; i < argsSize; ++i) {
                newArgs.add(args.get(i).toSQLText().toSQL());
            }
        } else if (argsSize > 0) {
            firstArgumentTypeMapping = args.get(0).getJavaTypeMapping();
            firstArgumentType = firstArgumentTypeMapping.getJavaType();
            newArgs.add(args.get(0).toSQLText().toSQL());
            for (i = 1; i < argsSize; ++i) {
                newArgs.add(args.get(i).toSQLText().toSQL());
            }
        }
        if ((returnTypeMapping = (returnType = this.function.getReturnType(firstArgumentType)) == firstArgumentType ? firstArgumentTypeMapping : this.getMappingForClass(returnType)) == null) {
            throw new IllegalArgumentException("Invalid return type null returned from function: " + this.function);
        }
        DataNucleusFunctionRenderContext context = new DataNucleusFunctionRenderContext(newArgs);
        this.function.render((FunctionRenderContext)context);
        final CustomSQLText sqlText = new CustomSQLText(context.renderToString(), expr, args);
        if (this.aggregate) {
            if (returnTypeMapping instanceof TemporalMapping) {
                return new AggregateTemporalExpression(this.stmt, returnTypeMapping, "", null){

                    public SQLText toSQLText() {
                        return sqlText;
                    }
                };
            }
            if (Number.class.isAssignableFrom(returnTypeMapping.getJavaType())) {
                return new AggregateNumericExpression(this.stmt, returnTypeMapping, ""){

                    public SQLText toSQLText() {
                        return sqlText;
                    }
                };
            }
            if (String.class.isAssignableFrom(returnTypeMapping.getJavaType())) {
                return new AggregateStringExpression(this.stmt, returnTypeMapping, "", null){

                    public SQLText toSQLText() {
                        return sqlText;
                    }
                };
            }
            LOG.warning("Aggregate type [" + returnType + "] could not be represented as aggregate. Please report this so we can support the type! Falling back to normal expression.");
        } else {
            if (returnTypeMapping instanceof TemporalMapping) {
                return new TemporalExpression(this.stmt, returnTypeMapping, "", null){

                    public SQLText toSQLText() {
                        return sqlText;
                    }
                };
            }
            if (Byte.class.isAssignableFrom(returnTypeMapping.getJavaType())) {
                return new ByteExpression(this.stmt, null, returnTypeMapping){

                    public SQLText toSQLText() {
                        return sqlText;
                    }
                };
            }
            if (Number.class.isAssignableFrom(returnTypeMapping.getJavaType())) {
                return new NumericExpression(this.stmt, returnTypeMapping, ""){

                    public SQLText toSQLText() {
                        return sqlText;
                    }
                };
            }
            if (String.class.isAssignableFrom(returnTypeMapping.getJavaType())) {
                return new StringExpression(this.stmt, null, returnTypeMapping){

                    public SQLText toSQLText() {
                        return sqlText;
                    }
                };
            }
            if (Character.class.isAssignableFrom(returnTypeMapping.getJavaType())) {
                return new CharacterExpression(this.stmt, null, returnTypeMapping){

                    public SQLText toSQLText() {
                        return sqlText;
                    }
                };
            }
            if (Boolean.class.isAssignableFrom(returnTypeMapping.getJavaType())) {
                return new BooleanExpression(this.stmt, returnTypeMapping, ""){

                    public SQLText toSQLText() {
                        return sqlText;
                    }
                };
            }
            LOG.warning("Type [" + returnType + "] could not be represented as aggregate. Please report this so we can support the type! Falling back to normal expression.");
        }
        return new SQLExpression(this.stmt, null, returnTypeMapping){

            public SQLText toSQLText() {
                return sqlText;
            }
        };
    }
}

