/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.view.spring.impl;

import com.blazebit.persistence.integration.view.spring.impl.AbstractEntityViewConfigurationSource;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AspectJTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class AnnotationEntityViewConfigurationSource
extends AbstractEntityViewConfigurationSource {
    private static final String BASE_PACKAGES = "basePackages";
    private static final String BASE_PACKAGE_CLASSES = "basePackageClasses";
    private final AnnotationMetadata configMetadata;
    private final AnnotationAttributes attributes;
    private final ResourceLoader resourceLoader;

    public AnnotationEntityViewConfigurationSource(AnnotationMetadata metadata, Class<? extends Annotation> annotation, ResourceLoader resourceLoader, Environment environment) {
        super(environment);
        Assert.notNull((Object)metadata, (String)"metadata must not be null");
        Assert.notNull(annotation, (String)"annotation must not be null");
        Assert.notNull((Object)resourceLoader, (String)"resourceLoader must not be null");
        this.attributes = new AnnotationAttributes(metadata.getAnnotationAttributes(annotation.getName()));
        this.configMetadata = metadata;
        this.resourceLoader = resourceLoader;
    }

    @Override
    public Iterable<String> getBasePackages() {
        String[] value = this.attributes.getStringArray("value");
        String[] basePackages = this.attributes.getStringArray(BASE_PACKAGES);
        Class[] basePackageClasses = this.attributes.getClassArray(BASE_PACKAGE_CLASSES);
        if (value.length == 0 && basePackages.length == 0 && basePackageClasses.length == 0) {
            String className = this.configMetadata.getClassName();
            return Collections.singleton(ClassUtils.getPackageName((String)className));
        }
        HashSet<String> packages = new HashSet<String>();
        packages.addAll(Arrays.asList(value));
        packages.addAll(Arrays.asList(basePackages));
        for (Class typeName : basePackageClasses) {
            packages.add(ClassUtils.getPackageName((Class)typeName));
        }
        return packages;
    }

    @Override
    protected Iterable<TypeFilter> getIncludeFilters() {
        return this.parseFilters("includeFilters");
    }

    @Override
    protected Iterable<TypeFilter> getExcludeFilters() {
        return this.parseFilters("excludeFilters");
    }

    private Set<TypeFilter> parseFilters(String attributeName) {
        AnnotationAttributes[] filters;
        HashSet<TypeFilter> result = new HashSet<TypeFilter>();
        for (AnnotationAttributes filter : filters = this.attributes.getAnnotationArray(attributeName)) {
            result.addAll(this.typeFiltersFor(filter));
        }
        return result;
    }

    private List<TypeFilter> typeFiltersFor(AnnotationAttributes filterAttributes) {
        ArrayList<TypeFilter> typeFilters = new ArrayList<TypeFilter>();
        FilterType filterType = (FilterType)filterAttributes.getEnum("type");
        block5: for (Class filterClass : filterAttributes.getClassArray("value")) {
            switch (filterType) {
                case ANNOTATION: {
                    Assert.isAssignable(Annotation.class, (Class)filterClass, (String)"An error occured when processing a @ComponentScan ANNOTATION type filter: ");
                    Class annoClass = filterClass;
                    typeFilters.add((TypeFilter)new AnnotationTypeFilter(annoClass));
                    continue block5;
                }
                case ASSIGNABLE_TYPE: {
                    typeFilters.add((TypeFilter)new AssignableTypeFilter(filterClass));
                    continue block5;
                }
                case CUSTOM: {
                    Assert.isAssignable(TypeFilter.class, (Class)filterClass, (String)"An error occured when processing a @ComponentScan CUSTOM type filter: ");
                    typeFilters.add((TypeFilter)BeanUtils.instantiateClass((Class)filterClass, TypeFilter.class));
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown filter type " + filterType);
                }
            }
        }
        for (String expression : this.getPatterns(filterAttributes)) {
            String rawName = filterType.toString();
            if ("REGEX".equals(rawName)) {
                typeFilters.add((TypeFilter)new RegexPatternTypeFilter(Pattern.compile(expression)));
                continue;
            }
            if ("ASPECTJ".equals(rawName)) {
                typeFilters.add((TypeFilter)new AspectJTypeFilter(expression, this.resourceLoader.getClassLoader()));
                continue;
            }
            throw new IllegalArgumentException("Unknown filter type " + filterType);
        }
        return typeFilters;
    }

    private String[] getPatterns(AnnotationAttributes filterAttributes) {
        try {
            return filterAttributes.getStringArray("pattern");
        }
        catch (IllegalArgumentException o_O) {
            return new String[0];
        }
    }
}

