/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.view.spring.impl;

import com.blazebit.persistence.view.spi.TransactionAccess;
import jakarta.transaction.Synchronization;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringTransactionSynchronizationStrategy
implements TransactionAccess {
    public static final SpringTransactionSynchronizationStrategy INSTANCE = new SpringTransactionSynchronizationStrategy();

    private SpringTransactionSynchronizationStrategy() {
    }

    public boolean isActive() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    public Object getTransaction() {
        Object transaction = TransactionSynchronizationManager.getResource((Object)INSTANCE);
        if (transaction == null) {
            transaction = new Object();
            TransactionSynchronizationManager.bindResource((Object)INSTANCE, (Object)transaction);
        }
        return transaction;
    }

    public void markRollbackOnly() {
        TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
    }

    public void registerSynchronization(Synchronization synchronization) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationWrapper(synchronization, TransactionSynchronizationManager.getResource((Object)INSTANCE)));
    }

    private static class TransactionSynchronizationWrapper
    implements TransactionSynchronization {
        private final Synchronization synchronization;
        private final Object transaction;

        public TransactionSynchronizationWrapper(Synchronization synchronization, Object transaction) {
            this.synchronization = synchronization;
            this.transaction = transaction;
        }

        public void suspend() {
            TransactionSynchronizationManager.unbindResource((Object)INSTANCE);
        }

        public void resume() {
            TransactionSynchronizationManager.bindResource((Object)INSTANCE, (Object)this.transaction);
        }

        public void flush() {
        }

        public void beforeCommit(boolean readOnly) {
        }

        public void beforeCompletion() {
            this.synchronization.beforeCompletion();
        }

        public void afterCommit() {
        }

        public void afterCompletion(int status) {
            switch (status) {
                case 0: {
                    status = 3;
                    break;
                }
                case 1: {
                    status = 4;
                    break;
                }
                default: {
                    status = 5;
                }
            }
            try {
                this.synchronization.afterCompletion(status);
            }
            finally {
                TransactionSynchronizationManager.unbindResource((Object)INSTANCE);
            }
        }
    }
}

