/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.view.spring.impl;

import com.blazebit.persistence.integration.view.spring.impl.AbstractEntityViewConfigurationSource;
import com.blazebit.persistence.integration.view.spring.impl.TypeFilterParser;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class XmlEntityViewConfigurationSource
extends AbstractEntityViewConfigurationSource {
    private static final String BASE_PACKAGE = "base-package";
    private final Element element;
    private final ParserContext context;
    private final Collection<TypeFilter> includeFilters;
    private final Collection<TypeFilter> excludeFilters;

    public XmlEntityViewConfigurationSource(Element element, ParserContext context, Environment environment) {
        super(environment);
        Assert.notNull((Object)element, (String)"element cannot be null");
        Assert.notNull((Object)context, (String)"context cannot be null");
        this.element = element;
        this.context = context;
        TypeFilterParser parser = new TypeFilterParser(context.getReaderContext());
        this.includeFilters = parser.parseTypeFilters(element, TypeFilterParser.Type.INCLUDE);
        this.excludeFilters = parser.parseTypeFilters(element, TypeFilterParser.Type.EXCLUDE);
    }

    @Override
    public Iterable<String> getBasePackages() {
        String attribute = this.element.getAttribute(BASE_PACKAGE);
        return Arrays.asList(StringUtils.delimitedListToStringArray((String)attribute, (String)",", (String)" "));
    }

    @Override
    protected Iterable<TypeFilter> getExcludeFilters() {
        return this.excludeFilters;
    }

    @Override
    protected Iterable<TypeFilter> getIncludeFilters() {
        return this.includeFilters;
    }
}

