/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.view.spring.impl;

import com.blazebit.persistence.integration.view.spring.EnableEntityViews;
import com.blazebit.persistence.integration.view.spring.impl.AnnotationEntityViewConfigurationSource;
import com.blazebit.persistence.integration.view.spring.impl.EntityViewConfigurationDelegate;
import com.blazebit.persistence.integration.view.spring.impl.XmlEntityViewConfigurationSource;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.ReaderContext;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.w3c.dom.Element;

public class EntityViewRegistrar
implements ImportBeanDefinitionRegistrar,
BeanDefinitionParser,
ResourceLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        try {
            Environment environment = parserContext.getReaderContext().getEnvironment();
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            XmlEntityViewConfigurationSource configurationSource = new XmlEntityViewConfigurationSource(element, parserContext, environment);
            if (!configurationSource.getBasePackages().iterator().hasNext()) {
                parserContext.getReaderContext().error("You have to specify at least one base package for entity views!", (Object)element);
            }
            EntityViewConfigurationDelegate delegate = new EntityViewConfigurationDelegate(configurationSource, this.resourceLoader, environment);
            delegate.registerEntityViews(registry);
        }
        catch (RuntimeException e) {
            this.handleError(e, element, (ReaderContext)parserContext.getReaderContext());
        }
        return null;
    }

    private void handleError(Exception e, Element source, ReaderContext reader) {
        reader.error(e.getMessage(), reader.extractSource((Object)source), (Throwable)e);
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationEntityViewConfigurationSource configurationSource = new AnnotationEntityViewConfigurationSource(importingClassMetadata, EnableEntityViews.class, this.resourceLoader, this.environment);
        EntityViewConfigurationDelegate delegate = new EntityViewConfigurationDelegate(configurationSource, this.resourceLoader, this.environment);
        delegate.registerEntityViews(registry);
    }
}

