/*
 * Copyright 2014 - 2022 Blazebit.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.blazebit.persistence.integration.view.spring.impl;

import com.blazebit.persistence.view.EntityView;
import com.blazebit.persistence.view.EntityViewListener;
import com.blazebit.persistence.view.EntityViewListeners;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;

import java.io.IOException;

/**
 * @author Moritz Becker
 * @since 1.2.0
 */
public class EntityViewComponentProvider extends ClassPathScanningCandidateComponentProvider {

    public EntityViewComponentProvider(Iterable<? extends TypeFilter> includeFilters) {
        super(false);

        Assert.notNull(includeFilters);

        if (includeFilters.iterator().hasNext()) {
            for (TypeFilter filter : includeFilters) {
                addIncludeFilter(filter);
            }
        } else {
            super.addIncludeFilter(new AnnotationTypeFilter(EntityView.class, false, false));
            super.addIncludeFilter(new AnnotationTypeFilter(EntityViewListener.class, false, false));
            super.addIncludeFilter(new AnnotationTypeFilter(EntityViewListeners.class, false, false));
        }
        super.addExcludeFilter(new TypeFilter() {
            @Override
            public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
                return !metadataReader.getAnnotationMetadata().hasAnnotation(EntityView.class.getName())
                        && !metadataReader.getAnnotationMetadata().hasAnnotation(EntityViewListener.class.getName())
                        && !metadataReader.getAnnotationMetadata().hasAnnotation(EntityViewListeners.class.getName());
            }
        });
    }

    @Override
    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isIndependent();
    }
}
