/*
 * Copyright 2014 - 2024 Blazebit.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.blazebit.persistence.integration.graphql.dgs.converter;

import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * Converter from {@link String} to {@link Byte}.
 *
 * @author Tom Mayer
 * @since 1.6.9
 */
@Component
public class ByteInputIdConverter implements EntityViewInputIdTypeConverter<Byte> {
    @Override
    public Set<Class<?>> getSupportedClasses() {
        return new HashSet<>(Arrays.asList(Byte.class, byte.class));
    }

    @Override
    public Byte convert(final String value) {
        return Byte.parseByte(value);
    }
}
