/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.graphql.dgs.mapper;

import com.blazebit.persistence.integration.graphql.dgs.converter.EntityViewInputIdTypeConverter;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodPluralAttribute;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.ViewType;
import com.netflix.graphql.dgs.internal.DefaultInputObjectMapper;
import com.netflix.graphql.dgs.internal.InputObjectMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class EntityViewInputObjectMapper
implements InputObjectMapper {
    private static final InputObjectMapper DEFAULT = new DefaultInputObjectMapper();
    private final EntityViewManager entityViewManager;
    private final ClassValue<EntityViewInputIdTypeConverter<?>> idTypeConverters;

    EntityViewInputObjectMapper(EntityViewManager entityViewManager, List<EntityViewInputIdTypeConverter<?>> converters) {
        this.entityViewManager = entityViewManager;
        final HashMap idTypeConverters = new HashMap(converters.size());
        for (EntityViewInputIdTypeConverter<?> converter : converters) {
            for (Class<?> supportedClass : converter.getSupportedClasses()) {
                idTypeConverters.put(supportedClass, converter);
            }
        }
        this.idTypeConverters = new ClassValue<EntityViewInputIdTypeConverter<?>>(){

            @Override
            protected EntityViewInputIdTypeConverter<?> computeValue(Class<?> type) {
                return (EntityViewInputIdTypeConverter)idTypeConverters.get(type);
            }
        };
    }

    @NotNull
    public <T> T mapToKotlinObject(@NotNull Map<String, ?> map, @NotNull KClass<T> kClass) {
        return (T)DEFAULT.mapToKotlinObject(map, kClass);
    }

    public <T> T mapToJavaObject(@NotNull Map<String, ?> map, @NotNull Class<T> entityViewClass) {
        ManagedViewType managedViewType = this.entityViewManager.getMetamodel().managedView(entityViewClass);
        if (managedViewType == null) {
            return (T)DEFAULT.mapToJavaObject(map, entityViewClass);
        }
        boolean updatable = managedViewType.isUpdatable();
        boolean creatable = managedViewType.isCreatable();
        Object reference = null;
        Object id = this.retrieveId(map, managedViewType, !creatable || updatable);
        if (creatable && (!updatable || id == null)) {
            reference = this.entityViewManager.create(entityViewClass);
        } else if (id != null) {
            reference = this.entityViewManager.getReference(entityViewClass, id);
        }
        if (reference == null || map.isEmpty()) {
            return (T)reference;
        }
        try {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                Object entityViewValue;
                String attributeName = entry.getKey();
                Object value = entry.getValue();
                AbstractMethodAttribute attribute = (AbstractMethodAttribute)managedViewType.getAttribute(attributeName);
                if (value != null) {
                    if (value instanceof Map) {
                        entityViewValue = this.mapToJavaObject((Map)value, attribute.getJavaType());
                    } else {
                        if (value instanceof Collection) {
                            AbstractMethodPluralAttribute pluralAttribute = (AbstractMethodPluralAttribute)attribute;
                            Class elementJavaType = pluralAttribute.getElementType().getJavaType();
                            Collection collection = (Collection)pluralAttribute.getJavaMethod().invoke(reference, new Object[0]);
                            if (elementJavaType.isEnum()) {
                                for (Object element : (Collection)value) {
                                    collection.add(Enum.valueOf(elementJavaType, element.toString()));
                                }
                                continue;
                            }
                            if (pluralAttribute.isSubview()) {
                                for (Object element : (Collection)value) {
                                    collection.add(this.mapToJavaObject((Map)element, elementJavaType));
                                }
                                continue;
                            }
                            collection.addAll((Collection)value);
                            continue;
                        }
                        entityViewValue = attribute.getJavaType().isEnum() ? Enum.valueOf(attribute.getJavaType(), value.toString()) : value;
                    }
                } else {
                    entityViewValue = null;
                }
                attribute.getSetterMethod().invoke(reference, entityViewValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't deserialize entity view", e);
        }
        return (T)reference;
    }

    private Object retrieveId(Map<String, ?> map, ManagedViewType<?> managedViewType, boolean consume) {
        Object id;
        MethodAttribute idAttribute;
        if (!(managedViewType instanceof ViewType) || (idAttribute = ((ViewType)managedViewType).getIdAttribute()) == null) {
            id = null;
        } else {
            Object value;
            String idAttributeName = idAttribute.getName();
            Object obj = value = consume ? map.remove(idAttributeName) : map.get(idAttributeName);
            if (value != null) {
                if (value instanceof Map) {
                    id = this.mapToJavaObject((Map)value, idAttribute.getJavaType());
                } else {
                    EntityViewInputIdTypeConverter<?> converter = this.idTypeConverters.get(idAttribute.getJavaType());
                    if (converter != null) {
                        try {
                            return converter.convert(value.toString());
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Couldn't deserialize entity view id attribute to type: " + idAttribute.getJavaType(), e);
                        }
                    }
                    id = value;
                }
            } else {
                id = null;
            }
        }
        return id;
    }
}

