/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.hibernate;

import com.blazebit.persistence.impl.hibernate.HibernateReturningResult;
import com.blazebit.persistence.impl.hibernate.StatementPreparerImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class JdbcCoordinatorInvocationHandler
implements InvocationHandler {
    private final JdbcCoordinator delegate;
    private final SessionFactoryImplementor sessionFactoryImplementor;
    private final boolean generated;
    private final String[][] columns;
    private final HibernateReturningResult<?> returningResult;
    private transient StatementPreparer statementPreparer;

    public JdbcCoordinatorInvocationHandler(JdbcCoordinator delegate, SessionFactoryImplementor sessionFactoryImplementor, boolean generated, String[][] columns, HibernateReturningResult<?> returningResult) {
        this.delegate = delegate;
        this.sessionFactoryImplementor = sessionFactoryImplementor;
        this.generated = generated;
        this.columns = columns;
        this.returningResult = returningResult;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("getStatementPreparer".equals(method.getName())) {
            if (this.statementPreparer == null) {
                this.statementPreparer = new StatementPreparerImpl(this.delegate, this.sessionFactoryImplementor, this.generated, this.columns, this.returningResult);
            }
            return this.statementPreparer;
        }
        return method.invoke((Object)this.delegate, args);
    }
}

