/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.hibernate;

import com.blazebit.persistence.impl.hibernate.HibernateReturningResult;
import com.blazebit.persistence.impl.hibernate.PreparedStatementInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.AssertionFailure;
import org.hibernate.ScrollMode;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class StatementPreparerImpl
implements StatementPreparer {
    private JdbcCoordinator jdbcCoordinator;
    private SessionFactoryImplementor sessionFactoryImplementor;
    private boolean generated;
    private String[][] columns;
    private HibernateReturningResult<?> returningResult;

    public StatementPreparerImpl(JdbcCoordinator jdbcCoordinator, SessionFactoryImplementor sessionFactoryImplementor, boolean generated, String[][] columns, HibernateReturningResult<?> returningResult) {
        this.jdbcCoordinator = jdbcCoordinator;
        this.sessionFactoryImplementor = sessionFactoryImplementor;
        this.generated = generated;
        this.columns = columns;
        this.returningResult = returningResult;
    }

    protected final Settings settings() {
        return this.sessionFactoryImplementor.getSettings();
    }

    protected final Connection connection() {
        return this.logicalConnection().getConnection();
    }

    protected final LogicalConnectionImplementor logicalConnection() {
        return this.jdbcCoordinator.getLogicalConnection();
    }

    protected final SqlExceptionHelper sqlExceptionHelper() {
        return this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().getTransactionEnvironment().getJdbcServices().getSqlExceptionHelper();
    }

    public Statement createStatement() {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public PreparedStatement prepareStatement(String sql) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public PreparedStatement prepareStatement(String sql, boolean isCallable) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    private void checkAutoGeneratedKeysSupportEnabled() {
        if (!this.settings().isGetGeneratedKeysEnabled()) {
            throw new AssertionFailure("getGeneratedKeys() support is not enabled");
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public PreparedStatement prepareQueryStatement(String sql, boolean isCallable, ScrollMode scrollMode) {
        this.checkAutoGeneratedKeysSupportEnabled();
        this.jdbcCoordinator.executeBatch();
        PreparedStatement ps = new QueryStatementPreparationTemplate(sql){

            @Override
            public PreparedStatement doPrepare() throws SQLException {
                if (StatementPreparerImpl.this.generated) {
                    return StatementPreparerImpl.this.connection().prepareStatement(this.sql, 1);
                }
                String[] columnNames = new String[StatementPreparerImpl.this.columns.length];
                for (int i = 0; i < StatementPreparerImpl.this.columns.length; ++i) {
                    columnNames[i] = StatementPreparerImpl.this.columns[i][0];
                }
                return StatementPreparerImpl.this.connection().prepareStatement(this.sql, columnNames);
            }
        }.prepareStatement();
        ps = (PreparedStatement)Proxy.newProxyInstance(ps.getClass().getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new PreparedStatementInvocationHandler(ps, this.columns, this.returningResult));
        this.jdbcCoordinator.registerLastQuery((Statement)ps);
        return ps;
    }

    private void setStatementFetchSize(PreparedStatement statement) throws SQLException {
        if (this.settings().getJdbcFetchSize() != null) {
            statement.setFetchSize(this.settings().getJdbcFetchSize());
        }
    }

    private abstract class QueryStatementPreparationTemplate
    extends StatementPreparationTemplate {
        protected QueryStatementPreparationTemplate(String sql) {
            super(sql);
        }

        @Override
        public void postProcess(PreparedStatement preparedStatement) throws SQLException {
            super.postProcess(preparedStatement);
            StatementPreparerImpl.this.setStatementFetchSize(preparedStatement);
        }
    }

    private abstract class StatementPreparationTemplate {
        protected final String sql;

        protected StatementPreparationTemplate(String sql) {
            this.sql = StatementPreparerImpl.this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().onPrepareStatement(sql);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PreparedStatement prepareStatement() {
            try {
                PreparedStatement preparedStatement;
                StatementPreparerImpl.this.jdbcCoordinator.getLogicalConnection().getJdbcServices().getSqlStatementLogger().logStatement(this.sql);
                try {
                    StatementPreparerImpl.this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().startPrepareStatement();
                    preparedStatement = this.doPrepare();
                    this.setStatementTimeout(preparedStatement);
                }
                finally {
                    StatementPreparerImpl.this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().endPrepareStatement();
                }
                this.postProcess(preparedStatement);
                return preparedStatement;
            }
            catch (SQLException e) {
                throw StatementPreparerImpl.this.sqlExceptionHelper().convert(e, "could not prepare statement", this.sql);
            }
        }

        protected abstract PreparedStatement doPrepare() throws SQLException;

        public void postProcess(PreparedStatement preparedStatement) throws SQLException {
            StatementPreparerImpl.this.jdbcCoordinator.register((Statement)preparedStatement);
            StatementPreparerImpl.this.logicalConnection().notifyObserversStatementPrepared();
        }

        private void setStatementTimeout(PreparedStatement preparedStatement) throws SQLException {
            int remainingTransactionTimeOutPeriod = StatementPreparerImpl.this.jdbcCoordinator.determineRemainingTransactionTimeOutPeriod();
            if (remainingTransactionTimeOutPeriod > 0) {
                preparedStatement.setQueryTimeout(remainingTransactionTimeOutPeriod);
            }
        }
    }
}

