/*
 * SPDX-License-Identifier: Apache-2.0
 * Copyright Blazebit
 */

package com.blazebit.persistence.integration.hibernate;

import org.hibernate.ScrollMode;
import org.hibernate.engine.jdbc.spi.StatementPreparer;

import java.sql.PreparedStatement;
import java.sql.Statement;

/**
 * @author Christian Beikov
 * @since 1.3.0
 */
public class DelegatingStatementPreparerImpl implements StatementPreparer {

    private StatementPreparer delegate;

    public DelegatingStatementPreparerImpl(StatementPreparer delegate) {
        this.delegate = delegate;
    }

    @Override
    public Statement createStatement() {
        return delegate.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) {
        return delegate.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, boolean isCallable) {
        return delegate.prepareStatement(sql, isCallable);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) {
        return delegate.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) {
        return delegate.prepareStatement(sql, columnNames);
    }

    @Override
    public PreparedStatement prepareQueryStatement(String sql, boolean isCallable, ScrollMode scrollMode) {
        return delegate.prepareQueryStatement(sql, isCallable, scrollMode);
    }
}
