/*
 * Copyright 2014 - 2023 Blazebit.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.blazebit.persistence.integration.hibernate;

import org.hibernate.ScrollMode;
import org.hibernate.engine.jdbc.spi.StatementPreparer;

import java.sql.PreparedStatement;
import java.sql.Statement;

/**
 * @author Christian Beikov
 * @since 1.3.0
 */
public class DelegatingStatementPreparerImpl implements StatementPreparer {

    private StatementPreparer delegate;

    public DelegatingStatementPreparerImpl(StatementPreparer delegate) {
        this.delegate = delegate;
    }

    @Override
    public Statement createStatement() {
        return delegate.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) {
        return delegate.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, boolean isCallable) {
        return delegate.prepareStatement(sql, isCallable);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) {
        return delegate.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) {
        return delegate.prepareStatement(sql, columnNames);
    }

    @Override
    public PreparedStatement prepareQueryStatement(String sql, boolean isCallable, ScrollMode scrollMode) {
        return delegate.prepareQueryStatement(sql, isCallable, scrollMode);
    }
}
