/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate;

import com.blazebit.persistence.integration.hibernate.DelegatingStatementPreparerImpl;
import com.blazebit.persistence.integration.hibernate.Hibernate56SessionInvocationHandler;
import com.blazebit.persistence.integration.hibernate.JdbcCoordinatorInvocationHandler;
import com.blazebit.persistence.integration.hibernate.SecondaryTableUpdateSupportingPreparedStatementInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashSet;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.tree.AssignmentSpecification;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.UpdateStatement;
import org.hibernate.hql.spi.id.MultiTableBulkIdStrategy;
import org.hibernate.hql.spi.id.TableBasedUpdateHandlerImpl;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.Queryable;

public class CustomTableBasedUpdateHandlerImpl
implements MultiTableBulkIdStrategy.UpdateHandler {
    private final TableBasedUpdateHandlerImpl delegate;
    private final String[] secondaryTableUpdates;
    private final String[] secondaryTableInserts;

    public CustomTableBasedUpdateHandlerImpl(TableBasedUpdateHandlerImpl delegate, HqlSqlWalker walker) {
        this.delegate = delegate;
        String[] updates = delegate.getSqlStatements();
        UpdateStatement updateStatement = (UpdateStatement)walker.getAST();
        FromElement fromElement = updateStatement.getFromClause().getFromElement();
        AbstractEntityPersister targetedPersister = (AbstractEntityPersister)fromElement.getQueryable();
        String[] tableNames = targetedPersister.getConstraintOrderedTableNameClosure();
        String[][] columnNames = targetedPersister.getContraintOrderedTableKeyColumnClosure();
        int subclassCount = delegate.getTargetedQueryable().getEntityMetamodel().getSubclassEntityNames().size();
        HashSet<String> subclassTableNames = new HashSet<String>();
        for (int i = 0; i < subclassCount; ++i) {
            subclassTableNames.add(delegate.getTargetedQueryable().getSubclassTableName(i));
        }
        String[] secondaryTableUpdates = (String[])updates.clone();
        String[] secondaryTableInserts = new String[updates.length];
        StringBuilder sb = new StringBuilder();
        StringBuilder selectSb = new StringBuilder();
        String selectString = "select ";
        String inString = "IN (";
        for (int tableIndex = 0; tableIndex < tableNames.length; ++tableIndex) {
            if (updates[tableIndex] == null) continue;
            if (subclassTableNames.contains(tableNames[tableIndex])) {
                secondaryTableUpdates[tableIndex] = null;
                continue;
            }
            sb.setLength(0);
            selectSb.setLength(0);
            boolean affected = false;
            String idSubselect = updates[tableIndex].substring(updates[tableIndex].lastIndexOf(inString) + inString.length(), updates[tableIndex].length() - 1);
            sb.append("insert into ").append(tableNames[tableIndex]);
            String[] keyColumnNames = columnNames[tableIndex];
            sb.append('(');
            ArrayList assignmentSpecifications = walker.getAssignmentSpecifications();
            for (AssignmentSpecification assignmentSpecification : assignmentSpecifications) {
                if (!assignmentSpecification.affectsTable(tableNames[tableIndex])) continue;
                String sqlAssignmentFragment = assignmentSpecification.getSqlAssignmentFragment();
                int eqIndex = sqlAssignmentFragment.indexOf(61);
                sb.append(sqlAssignmentFragment, 0, eqIndex);
                sb.append(',');
                selectSb.append(sqlAssignmentFragment, eqIndex + 1, sqlAssignmentFragment.length());
                selectSb.append(',');
                affected = true;
            }
            if (affected) {
                int i;
                for (i = 0; i < keyColumnNames.length; ++i) {
                    sb.append(keyColumnNames[i]);
                    sb.append(',');
                }
                sb.setCharAt(sb.length() - 1, ')');
                sb.append(' ').append(selectString);
                sb.append((CharSequence)selectSb);
                sb.append(idSubselect, selectString.length(), idSubselect.length());
                sb.append(" where not exists (select 1 from ");
                sb.append(tableNames[tableIndex]);
                sb.append(" a where ");
                for (i = 0; i < keyColumnNames.length; ++i) {
                    sb.append("a.");
                    sb.append(keyColumnNames[i]);
                    sb.append(" = ");
                    sb.append(keyColumnNames[i]);
                    sb.append(" and ");
                }
                sb.setLength(sb.length() - " and ".length());
                sb.append(")");
                secondaryTableInserts[tableIndex] = sb.toString();
            }
            updates[tableIndex] = "";
        }
        this.secondaryTableUpdates = secondaryTableUpdates;
        this.secondaryTableInserts = secondaryTableInserts;
    }

    public int execute(SharedSessionContractImplementor s, QueryParameters queryParameters) {
        final SessionImplementor session = (SessionImplementor)s;
        final JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        Object jdbcCoordinatorProxy = Proxy.newProxyInstance(jdbcCoordinator.getClass().getClassLoader(), new Class[]{JdbcCoordinator.class}, (InvocationHandler)new JdbcCoordinatorInvocationHandler(jdbcCoordinator, new DelegatingStatementPreparerImpl(jdbcCoordinator.getStatementPreparer()){
            PreparedStatement statementProxy;
            SecondaryTableUpdateSupportingPreparedStatementInvocationHandler invocationHandler;

            @Override
            public PreparedStatement prepareStatement(String sql, boolean isCallable) {
                if (sql.isEmpty()) {
                    this.invocationHandler.prepareNext();
                    return this.statementProxy;
                }
                PreparedStatement insertStatement = super.prepareStatement(sql, isCallable);
                this.invocationHandler = new SecondaryTableUpdateSupportingPreparedStatementInvocationHandler(session, jdbcCoordinator.getStatementPreparer(), insertStatement, CustomTableBasedUpdateHandlerImpl.this.secondaryTableUpdates, CustomTableBasedUpdateHandlerImpl.this.secondaryTableInserts);
                this.statementProxy = (PreparedStatement)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)this.invocationHandler);
                return this.statementProxy;
            }
        }));
        SessionImplementor sessionProxy = (SessionImplementor)Proxy.newProxyInstance(session.getClass().getClassLoader(), new Class[]{SessionImplementor.class, EventSource.class}, (InvocationHandler)new Hibernate56SessionInvocationHandler(session, jdbcCoordinatorProxy));
        return this.delegate.execute((SharedSessionContractImplementor)sessionProxy, queryParameters);
    }

    public Queryable getTargetedQueryable() {
        return this.delegate.getTargetedQueryable();
    }

    public String[] getSqlStatements() {
        return this.delegate.getSqlStatements();
    }
}

