/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate;

import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.DbmsLimitHandler;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.engine.spi.RowSelection;

public class Hibernate56LimitHandler
implements LimitHandler {
    private final DbmsLimitHandler limitHandler;
    private Integer limit;
    private Integer offset;

    public Hibernate56LimitHandler(Dialect dialect, DbmsDialect dbmsDialect) {
        this.limitHandler = dbmsDialect.createLimitHandler();
    }

    public boolean supportsLimit() {
        return this.limitHandler.supportsLimit();
    }

    public boolean supportsLimitOffset() {
        return this.limitHandler.supportsLimitOffset();
    }

    public String processSql(String sql, RowSelection selection) {
        this.limit = selection == null || selection.getMaxRows() == null || selection.getMaxRows() == Integer.MAX_VALUE ? null : selection.getMaxRows();
        this.offset = selection == null || selection.getFirstRow() == null || selection.getFirstRow() < 1 ? null : selection.getFirstRow();
        return this.limitHandler.applySql(sql, false, this.limit, this.offset);
    }

    public int bindLimitParametersAtStartOfQuery(RowSelection selection, PreparedStatement statement, int index) throws SQLException {
        return this.limitHandler.bindLimitParametersAtStartOfQuery(this.limit, this.offset, statement, index);
    }

    public int bindLimitParametersAtEndOfQuery(RowSelection selection, PreparedStatement statement, int index) throws SQLException {
        return this.limitHandler.bindLimitParametersAtEndOfQuery(this.limit, this.offset, statement, index);
    }

    public void setMaxRows(RowSelection selection, PreparedStatement statement) throws SQLException {
        this.limitHandler.setMaxRows(this.limit, this.offset, statement);
    }
}

