/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.hibernate.engine.spi.SessionImplementor;

public class SecondaryTableUpdateSupportingPreparedStatementInvocationHandler
implements InvocationHandler {
    private final SessionImplementor session;
    private final StatementPreparer statementPreparer;
    private final PreparedStatement insertStatement;
    private final String[] updates;
    private final String[] inserts;
    private final List<Map.Entry<Method, Object[]>> parameters = new ArrayList<Map.Entry<Method, Object[]>>();
    private PreparedStatement preparedStatement;
    private int index;
    private int insertCount;

    public SecondaryTableUpdateSupportingPreparedStatementInvocationHandler(SessionImplementor session, StatementPreparer statementPreparer, PreparedStatement insertStatement, String[] updates, String[] inserts) {
        this.session = session;
        this.statementPreparer = statementPreparer;
        this.insertStatement = insertStatement;
        this.updates = updates;
        this.inserts = inserts;
    }

    public void prepareNext() {
        this.preparedStatement = null;
        this.parameters.clear();
        while (this.index < this.updates.length) {
            String updateSql;
            if ((updateSql = this.updates[this.index++]) == null) continue;
            this.preparedStatement = this.statementPreparer.prepareStatement(updateSql, false);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        PreparedStatement s = this.preparedStatement == null ? this.insertStatement : this.preparedStatement;
        if ("executeUpdate".equals(method.getName()) && method.getParameterTypes().length == 0) {
            if (this.preparedStatement == null) {
                this.insertCount = this.insertStatement.executeUpdate();
                return this.insertCount;
            }
            int updateRows = this.preparedStatement.executeUpdate();
            if (updateRows != this.insertCount) {
                PreparedStatement ps = null;
                int i = this.index - 1;
                try {
                    ps = this.statementPreparer.prepareStatement(this.inserts[i], false);
                    for (Map.Entry<Method, Object[]> entry : this.parameters) {
                        entry.getKey().invoke((Object)ps, entry.getValue());
                    }
                    this.session.getJdbcCoordinator().getResultSetReturn().executeUpdate(ps);
                }
                finally {
                    if (ps != null) {
                        this.session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release((Statement)ps);
                        this.session.getJdbcCoordinator().afterStatementExecution();
                    }
                }
            }
            return 0;
        }
        if (method.getName().startsWith("set")) {
            this.parameters.add(new AbstractMap.SimpleEntry<Method, Object[]>(method, args));
        }
        return method.invoke((Object)s, args);
    }
}

