/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate;

import com.blazebit.persistence.view.spi.TransactionAccess;
import com.blazebit.persistence.view.spi.TransactionSupport;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.transaction.Synchronization;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.resource.transaction.spi.SynchronizationRegistry;

public class Hibernate5EntityTransactionSynchronizationStrategy
implements TransactionAccess,
TransactionSupport {
    private final EntityTransaction tx;
    private final SynchronizationRegistry synchronizationRegistry;

    public Hibernate5EntityTransactionSynchronizationStrategy(EntityManager em) {
        try {
            this.tx = em.getTransaction();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Could not access entity transaction!", e);
        }
        Session s = (Session)em.unwrap(Session.class);
        this.synchronizationRegistry = ((SessionImplementor)s).getTransactionCoordinator().getLocalSynchronizations();
    }

    public boolean isActive() {
        return this.tx.isActive();
    }

    public void markRollbackOnly() {
        this.tx.setRollbackOnly();
    }

    public void registerSynchronization(Synchronization synchronization) {
        this.synchronizationRegistry.registerSynchronization(synchronization);
    }

    public void transactional(Runnable runnable) {
        runnable.run();
    }
}

