/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate.base.function;

import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;
import org.hibernate.MappingException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;

public class HibernateSQLFunctionAdapter
implements JpqlFunction {
    private final SessionFactoryImplementor sfi;
    private final SQLFunction function;

    public HibernateSQLFunctionAdapter(SessionFactoryImplementor sfi, SQLFunction function) {
        this.sfi = sfi;
        this.function = function;
    }

    public boolean hasArguments() {
        return this.function.hasArguments();
    }

    public boolean hasParenthesesIfNoArguments() {
        return this.function.hasParenthesesIfNoArguments();
    }

    public Class<?> getReturnType(Class<?> firstArgumentType) {
        Type returnType;
        if (firstArgumentType == null) {
            return null;
        }
        BasicType type = this.sfi.getTypeHelper().basic(firstArgumentType);
        if (type == null) {
            if (this.sfi.getEntityPersisters().get(firstArgumentType.getName()) != null) {
                type = this.sfi.getTypeHelper().entity(firstArgumentType);
            } else {
                try {
                    type = this.sfi.getTypeHelper().custom(firstArgumentType);
                }
                catch (MappingException ex) {
                    type = this.sfi.getTypeHelper().heuristicType(firstArgumentType.getName());
                }
            }
        }
        if (type != null && (returnType = this.function.getReturnType((Type)type, (Mapping)this.sfi)) != null) {
            return returnType.getReturnedClass();
        }
        return null;
    }

    public void render(FunctionRenderContext context) {
        throw new UnsupportedOperationException("Rendering functions through this API is not possible!");
    }
}

