/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate.base;

import java.io.Closeable;
import java.util.Iterator;
import org.hibernate.ScrollableResults;

public class ScrollableResultsIterator
implements Iterator<Object>,
Closeable {
    private final ScrollableResults scrollableResults;
    private Object[] next;

    public ScrollableResultsIterator(ScrollableResults scrollableResults) {
        this.scrollableResults = scrollableResults;
    }

    @Override
    public boolean hasNext() {
        return this.next != null || this.scrollableResults.next() && (this.next = this.scrollableResults.get()) != null;
    }

    @Override
    public Object next() {
        Object[] next = this.next;
        this.next = null;
        if (next.length == 1) {
            return next[0];
        }
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void close() {
        this.scrollableResults.close();
    }
}

