/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate.base;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import org.hibernate.engine.spi.QueryParameters;

public class SubselectPreparedStatementProxyHandler
implements InvocationHandler {
    private final PreparedStatement delegate;
    private final QueryParameters queryParameters;
    private final int cteParameterCount;
    private final int selectParameterCount;

    public SubselectPreparedStatementProxyHandler(PreparedStatement delegate, QueryParameters queryParameters, int cteParameterCount, int selectParameterCount) {
        this.delegate = delegate;
        this.queryParameters = queryParameters;
        this.cteParameterCount = cteParameterCount;
        this.selectParameterCount = selectParameterCount;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().startsWith("set") && args.length >= 2) {
            boolean isNamedParamCte;
            int index = (Integer)args[0];
            int positionalParameterCount = this.queryParameters.getFilteredPositionalParameterTypes().length;
            int ctePositionedParameterStartIndex = 1;
            int cteNamedParameterStartIndex = ctePositionedParameterStartIndex + positionalParameterCount;
            int regularNamedParameterStartIndex = cteNamedParameterStartIndex + this.cteParameterCount;
            boolean isPositionedParamRegular = index < cteNamedParameterStartIndex;
            boolean bl = isNamedParamCte = index < regularNamedParameterStartIndex;
            if ((index += isPositionedParamRegular ? this.cteParameterCount : (isNamedParamCte ? -positionalParameterCount : 0)) > this.cteParameterCount && (index -= this.selectParameterCount) <= this.cteParameterCount) {
                return null;
            }
            args[0] = index;
        }
        return method.invoke((Object)this.delegate, args);
    }
}

