/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate.base.function;

import com.blazebit.persistence.integration.hibernate.base.function.HibernateJpqlFunctionAdapter;
import com.blazebit.persistence.integration.hibernate.base.function.HibernateSQLFunctionAdapter;
import com.blazebit.persistence.integration.hibernate.base.spi.HibernateVersionProvider;
import com.blazebit.persistence.spi.EntityManagerFactoryIntegrator;
import com.blazebit.persistence.spi.JpqlFunction;
import com.blazebit.persistence.spi.JpqlFunctionGroup;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.hibernate.Session;
import org.hibernate.Version;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionRegistry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;

public abstract class AbstractHibernateEntityManagerFactoryIntegrator
implements EntityManagerFactoryIntegrator {
    protected static final int MAJOR;
    protected static final int MINOR;
    protected static final int FIX;
    protected static final String TYPE;
    private static final Logger LOG;
    private static final boolean USE_FUNCTION_REGISTRY;
    private static final String VERSION_STRING;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getDbmsName(EntityManagerFactory emf, EntityManager em, Dialect dialect) {
        Set<String> classNames = this.getClassNames(dialect);
        if (classNames.contains("org.hibernate.dialect.MySQL8Dialect")) return "mysql8";
        if (classNames.contains("org.hibernate.dialect.MariaDB10Dialect")) {
            return "mysql8";
        }
        if (classNames.contains("org.hibernate.dialect.MySQLDialect")) {
            try {
                boolean close = em == null;
                EntityManager entityManager = em == null ? emf.createEntityManager() : em;
                try {
                    Connection connection = ((SessionImplementor)entityManager.unwrap(SessionImplementor.class)).connection();
                    if (connection.getMetaData().getDatabaseMajorVersion() > 7) {
                        String string2 = "mysql8";
                        return string2;
                    }
                    String string = "mysql";
                    return string;
                }
                finally {
                    if (close) {
                        entityManager.close();
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not determine the MySQL Server version!", ex);
            }
        }
        if (classNames.contains("org.hibernate.dialect.DB2Dialect")) {
            return "db2";
        }
        if (classNames.contains("org.hibernate.dialect.PostgreSQL81Dialect")) return "postgresql";
        if (classNames.contains("org.hibernate.dialect.PostgreSQLDialect")) {
            return "postgresql";
        }
        if (classNames.contains("org.hibernate.dialect.Oracle8iDialect")) return "oracle";
        if (classNames.contains("org.hibernate.dialect.Oracle9Dialect")) return "oracle";
        if (classNames.contains("org.hibernate.dialect.OracleDialect")) {
            return "oracle";
        }
        if (classNames.contains("org.hibernate.dialect.SQLServerDialect")) {
            return "microsoft";
        }
        if (classNames.contains("org.hibernate.dialect.SybaseDialect")) {
            return "sybase";
        }
        if (classNames.contains("org.hibernate.dialect.H2Dialect")) {
            return "h2";
        }
        if (classNames.contains("org.hibernate.dialect.CUBRIDDialect")) {
            return "cubrid";
        }
        if (classNames.contains("org.hibernate.dialect.HSQLDialect")) {
            return "hsql";
        }
        if (classNames.contains("org.hibernate.dialect.InformixDialect")) {
            return "informix";
        }
        if (classNames.contains("org.hibernate.dialect.IngresDialect")) {
            return "ingres";
        }
        if (classNames.contains("org.hibernate.dialect.InterbaseDialect")) {
            return "interbase";
        }
        if (!classNames.contains("org.hibernate.dialect.CockroachDB192Dialect")) return null;
        return "cockroach";
    }

    private Set<String> getClassNames(Dialect dialect) {
        HashSet<String> classNames = new HashSet<String>();
        Class<?> c = dialect.getClass();
        do {
            classNames.add(c.getName());
        } while ((c = c.getSuperclass()) != Object.class);
        return classNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory registerFunctions(EntityManagerFactory entityManagerFactory, Map<String, JpqlFunctionGroup> dbmsFunctions) {
        try (EntityManager em = null;){
            em = entityManagerFactory.createEntityManager();
            Session s = (Session)em.unwrap(Session.class);
            Map<String, SQLFunction> originalFunctions = this.getFunctions(s);
            TreeMap<String, SQLFunction> functions = new TreeMap<String, SQLFunction>(String.CASE_INSENSITIVE_ORDER);
            functions.putAll(originalFunctions);
            Dialect dialect = this.getDialect(s);
            String dbms = this.getDbmsName(entityManagerFactory, em, dialect);
            for (Map.Entry<String, JpqlFunctionGroup> functionEntry : dbmsFunctions.entrySet()) {
                String functionName = functionEntry.getKey();
                JpqlFunctionGroup dbmsFunctionMap = functionEntry.getValue();
                JpqlFunction function = dbmsFunctionMap.get(dbms);
                if (function == null && !dbmsFunctionMap.contains(dbms)) {
                    function = dbmsFunctionMap.get(null);
                }
                if (function == null) {
                    if (functions.containsKey(functionName)) {
                        LOG.finest("Using ORM registered function '" + functionName + "' because there is neither an implementation for the dbms '" + dbms + "' nor a default implementation.");
                        continue;
                    }
                    LOG.warning("Could not register the function '" + functionName + "' because there is neither an implementation for the dbms '" + dbms + "' nor a default implementation!");
                    continue;
                }
                functions.put(functionName, new HibernateJpqlFunctionAdapter(function));
            }
            this.replaceFunctions(s, functions);
            EntityManagerFactory entityManagerFactory2 = entityManagerFactory;
            return entityManagerFactory2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, JpqlFunction> getRegisteredFunctions(EntityManagerFactory entityManagerFactory) {
        try (EntityManager em = null;){
            em = entityManagerFactory.createEntityManager();
            Session s = (Session)em.unwrap(Session.class);
            SessionFactoryImplementor sf = (SessionFactoryImplementor)s.getSessionFactory();
            Map<String, SQLFunction> functions = this.getFunctions(s);
            HashMap<String, JpqlFunction> map = new HashMap<String, JpqlFunction>(functions.size());
            for (Map.Entry<String, SQLFunction> entry : functions.entrySet()) {
                SQLFunction function = entry.getValue();
                if (function instanceof HibernateJpqlFunctionAdapter) {
                    map.put(entry.getKey(), ((HibernateJpqlFunctionAdapter)function).unwrap());
                    continue;
                }
                map.put(entry.getKey(), new HibernateSQLFunctionAdapter(sf, entry.getValue()));
            }
            HashMap<String, JpqlFunction> hashMap = map;
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, SQLFunction> getFunctions(Session s) {
        if (USE_FUNCTION_REGISTRY) {
            Exception ex;
            SessionFactoryImplementor sf = (SessionFactoryImplementor)s.getSessionFactory();
            SQLFunctionRegistry registry = sf.getSqlFunctionRegistry();
            Field f = null;
            boolean madeAccessible = false;
            try {
                f = SQLFunctionRegistry.class.getDeclaredField("functionMap");
                boolean bl = madeAccessible = !f.isAccessible();
                if (madeAccessible) {
                    f.setAccessible(true);
                }
                Map map = (Map)f.get(registry);
                return map;
            }
            catch (NoSuchFieldException e) {
                ex = e;
            }
            catch (IllegalArgumentException e) {
                ex = e;
            }
            catch (IllegalAccessException e) {
                ex = e;
            }
            finally {
                if (f != null && madeAccessible) {
                    f.setAccessible(false);
                }
            }
            throw new RuntimeException("Could not access the function map to dynamically register functions. Please report the version of hibernate your are using so we can provide support for it!", ex);
        }
        return this.getDialect(s).getFunctions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceFunctions(Session s, Map<String, SQLFunction> newFunctions) {
        Exception ex;
        if (USE_FUNCTION_REGISTRY) {
            Exception ex2;
            SessionFactoryImplementor sf = (SessionFactoryImplementor)s.getSessionFactory();
            SQLFunctionRegistry registry = sf.getSqlFunctionRegistry();
            Field f = null;
            boolean madeAccessible = false;
            try {
                f = SQLFunctionRegistry.class.getDeclaredField("functionMap");
                boolean bl = madeAccessible = !f.isAccessible();
                if (madeAccessible) {
                    f.setAccessible(true);
                }
                f.set(registry, newFunctions);
                return;
            }
            catch (NoSuchFieldException e) {
                ex2 = e;
            }
            catch (IllegalArgumentException e) {
                ex2 = e;
            }
            catch (IllegalAccessException e) {
                ex2 = e;
            }
            finally {
                if (f != null && madeAccessible) {
                    f.setAccessible(false);
                }
            }
            throw new RuntimeException("Could not access the function map to dynamically register functions. Please report the version of hibernate your are using so we can provide support for it!", ex2);
        }
        Field f = null;
        boolean madeAccessible = false;
        try {
            f = Dialect.class.getDeclaredField("sqlFunctions");
            boolean bl = madeAccessible = !f.isAccessible();
            if (madeAccessible) {
                f.setAccessible(true);
            }
            f.set(this.getDialect(s), newFunctions);
            return;
        }
        catch (NoSuchFieldException e) {
            ex = e;
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        finally {
            if (f != null && madeAccessible) {
                f.setAccessible(false);
            }
        }
        throw new RuntimeException("Could not access the function map to dynamically register functions. Please report the version of hibernate your are using so we can provide support for it!", ex);
    }

    protected Dialect getDialect(Session s) {
        SessionFactoryImplementor sf = (SessionFactoryImplementor)s.getSessionFactory();
        return sf.getDialect();
    }

    static {
        LOG = Logger.getLogger(EntityManagerFactoryIntegrator.class.getName());
        HibernateVersionProvider usedProvider = null;
        try {
            Iterator<HibernateVersionProvider> iter = ServiceLoader.load(HibernateVersionProvider.class).iterator();
            if (iter.hasNext()) {
                usedProvider = iter.next();
                VERSION_STRING = usedProvider.getVersion();
            } else {
                String versionString = Version.getVersionString();
                if ("[WORKING]".equals(versionString)) {
                    try {
                        Method getModule = Class.class.getMethod("getModule", new Class[0]);
                        Method getDescriptor = getModule.getReturnType().getMethod("getDescriptor", new Class[0]);
                        Method version = getDescriptor.getReturnType().getMethod("version", new Class[0]);
                        Method get = version.getReturnType().getMethod("get", new Class[0]);
                        Object module = getModule.invoke(Version.class, new Object[0]);
                        Object descriptor = getDescriptor.invoke(module, new Object[0]);
                        Object versionOptional = version.invoke(descriptor, new Object[0]);
                        versionString = get.invoke(versionOptional, new Object[0]).toString();
                    }
                    catch (NoSuchMethodException ex) {
                        throw new IllegalArgumentException("Error while trying to resolve the Hibernate version. This can happen when using an uber-jar deployment. In that case, please provide a service provider implementation of " + HibernateVersionProvider.class.getName());
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException("An error happened while trying to resolve the Hibernate version through the module version descriptor", ex);
                    }
                }
                VERSION_STRING = versionString;
            }
            String[] parts = VERSION_STRING.split("[\\.-]");
            MAJOR = Integer.parseInt(parts[0]);
            MINOR = Integer.parseInt(parts[1]);
            FIX = Integer.parseInt(parts[2]);
            TYPE = parts[3];
        }
        catch (RuntimeException ex) {
            if (usedProvider == null) {
                throw new IllegalArgumentException("Error while trying to resolve the Hibernate version. This can happen when using an uber-jar deployment. In that case, please provide a service provider implementation of " + HibernateVersionProvider.class.getName(), ex);
            }
            throw new IllegalArgumentException("An error happened while trying to resolve the Hibernate version through the version provider " + usedProvider.getClass().getName(), ex);
        }
        boolean useFunctionRegistry = false;
        try {
            SQLFunctionRegistry.class.getDeclaredField("userFunctions");
        }
        catch (NoSuchFieldException ex) {
            useFunctionRegistry = true;
        }
        USE_FUNCTION_REGISTRY = useFunctionRegistry;
    }
}

