/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate.base;

import com.blazebit.persistence.integration.hibernate.base.HibernateReturningResult;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class ResultSetInvocationHandler
implements InvocationHandler {
    private static final Map<String, Method> METHODS = new HashMap<String, Method>();
    private static final Method GET_OBJECT_FOR_CLASS_METHOD;
    private static final Method GET_OBJECT_FOR_MAP_METHOD;
    private final ResultSet delegate;
    private final Map<String, Integer> aliasIndex;
    private final HibernateReturningResult<?> returningResult;
    private final boolean calculateRowCount;
    private int rowCount = 0;

    public ResultSetInvocationHandler(ResultSet delegate, Map<String, Integer> aliasIndex, HibernateReturningResult<?> returningResult) {
        this.delegate = delegate;
        this.aliasIndex = aliasIndex;
        this.returningResult = returningResult;
        this.calculateRowCount = returningResult != null;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method indexMethod;
        int parameterCount = method.getParameterTypes().length;
        if (parameterCount == 1 && (indexMethod = METHODS.get(method.getName())) != null) {
            return indexMethod.invoke((Object)this.delegate, this.aliasIndex.get(args[0]));
        }
        if (parameterCount > 1) {
            indexMethod = METHODS.get(method.getName() + parameterCount);
            if (indexMethod != null) {
                Object[] newArgs = new Object[args.length];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                newArgs[0] = this.aliasIndex.get(args[0]);
                return indexMethod.invoke((Object)this.delegate, newArgs);
            }
            if ("getObject".equals(method.getName())) {
                Object[] newArgs = new Object[args.length];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                newArgs[0] = this.aliasIndex.get(args[0]);
                if (method.getParameterTypes()[1].equals(Class.class)) {
                    return GET_OBJECT_FOR_CLASS_METHOD.invoke((Object)this.delegate, newArgs);
                }
                return GET_OBJECT_FOR_MAP_METHOD.invoke((Object)this.delegate, newArgs);
            }
        } else if (this.calculateRowCount) {
            if ("next".equals(method.getName())) {
                Object result = method.invoke((Object)this.delegate, args);
                if (((Boolean)result).booleanValue()) {
                    ++this.rowCount;
                }
                return result;
            }
            if ("close".equals(method.getName())) {
                this.returningResult.setUpdateCount(this.rowCount);
            }
        }
        return method.invoke((Object)this.delegate, args);
    }

    static {
        try {
            METHODS.put("getString", ResultSet.class.getMethod("getString", Integer.TYPE));
            METHODS.put("getBoolean", ResultSet.class.getMethod("getBoolean", Integer.TYPE));
            METHODS.put("getByte", ResultSet.class.getMethod("getByte", Integer.TYPE));
            METHODS.put("getShort", ResultSet.class.getMethod("getShort", Integer.TYPE));
            METHODS.put("getInt", ResultSet.class.getMethod("getInt", Integer.TYPE));
            METHODS.put("getLong", ResultSet.class.getMethod("getLong", Integer.TYPE));
            METHODS.put("getFloat", ResultSet.class.getMethod("getFloat", Integer.TYPE));
            METHODS.put("getDouble", ResultSet.class.getMethod("getDouble", Integer.TYPE));
            METHODS.put("getBigDecimal", ResultSet.class.getMethod("getBigDecimal", Integer.TYPE));
            METHODS.put("getBytes", ResultSet.class.getMethod("getBytes", Integer.TYPE));
            METHODS.put("getDate", ResultSet.class.getMethod("getDate", Integer.TYPE));
            METHODS.put("getTime", ResultSet.class.getMethod("getTime", Integer.TYPE));
            METHODS.put("getTimestamp", ResultSet.class.getMethod("getTimestamp", Integer.TYPE));
            METHODS.put("getAsciiStream", ResultSet.class.getMethod("getAsciiStream", Integer.TYPE));
            METHODS.put("getUnicodeStream", ResultSet.class.getMethod("getUnicodeStream", Integer.TYPE));
            METHODS.put("getBinaryStream", ResultSet.class.getMethod("getBinaryStream", Integer.TYPE));
            METHODS.put("getObject", ResultSet.class.getMethod("getObject", Integer.TYPE));
            METHODS.put("getCharacterStream", ResultSet.class.getMethod("getCharacterStream", Integer.TYPE));
            METHODS.put("getRef", ResultSet.class.getMethod("getRef", Integer.TYPE));
            METHODS.put("getBlob", ResultSet.class.getMethod("getBlob", Integer.TYPE));
            METHODS.put("getClob", ResultSet.class.getMethod("getClob", Integer.TYPE));
            METHODS.put("getArray", ResultSet.class.getMethod("getArray", Integer.TYPE));
            METHODS.put("getURL", ResultSet.class.getMethod("getURL", Integer.TYPE));
            METHODS.put("getRowId", ResultSet.class.getMethod("getRowId", Integer.TYPE));
            METHODS.put("getNClob", ResultSet.class.getMethod("getNClob", Integer.TYPE));
            METHODS.put("getSQLXML", ResultSet.class.getMethod("getSQLXML", Integer.TYPE));
            METHODS.put("getNString", ResultSet.class.getMethod("getNString", Integer.TYPE));
            METHODS.put("getNCharacterStream", ResultSet.class.getMethod("getNCharacterStream", Integer.TYPE));
            METHODS.put("getBigDecimal2", ResultSet.class.getMethod("getBigDecimal", Integer.TYPE, Integer.TYPE));
            METHODS.put("getDate2", ResultSet.class.getMethod("getDate", Integer.TYPE, Calendar.class));
            METHODS.put("getTime2", ResultSet.class.getMethod("getTime", Integer.TYPE, Calendar.class));
            METHODS.put("getTimestamp2", ResultSet.class.getMethod("getTimestamp", Integer.TYPE, Calendar.class));
            GET_OBJECT_FOR_CLASS_METHOD = ResultSet.class.getMethod("getObject", Integer.TYPE, Class.class);
            GET_OBJECT_FOR_MAP_METHOD = ResultSet.class.getMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
    }
}

