/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate.base;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;

public final class HibernateAccessUtils {
    private static final Method GET_SQM_FUNCTION_REGISTRY;
    private static final Method GET_SQM_TRANSLATOR_FACTORY;

    private HibernateAccessUtils() {
    }

    public static SqmFunctionRegistry getSqmFunctionRegistry(SessionFactoryImplementor factory) {
        try {
            return (SqmFunctionRegistry)GET_SQM_FUNCTION_REGISTRY.invoke((Object)factory.getQueryEngine(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Couldn't access SqmFunctionRegistry", e);
        }
    }

    public static SqmTranslatorFactory getSqmTranslatorFactory(SessionFactoryImplementor factory) {
        try {
            return (SqmTranslatorFactory)GET_SQM_TRANSLATOR_FACTORY.invoke((Object)factory.getQueryEngine(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Couldn't access SqmTranslatorFactory", e);
        }
    }

    static {
        Method getSqmTranslatorFactory;
        Method getSqmFunctionRegistry;
        try {
            getSqmFunctionRegistry = QueryEngine.class.getMethod("getSqmFunctionRegistry", new Class[0]);
            getSqmTranslatorFactory = QueryEngine.class.getMethod("getSqmTranslatorFactory", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Couldn't setup the Blaze-Persistence Hibernate integration. Please report this problem!", e);
        }
        GET_SQM_FUNCTION_REGISTRY = getSqmFunctionRegistry;
        GET_SQM_TRANSLATOR_FACTORY = getSqmTranslatorFactory;
    }
}

