/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate.base;

import com.blazebit.persistence.integration.hibernate.base.HibernateReturningResult;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.ResultSet;

public class ResultSetInvocationHandler
implements InvocationHandler {
    private final ResultSet delegate;
    private final HibernateReturningResult<?> returningResult;
    private final boolean calculateRowCount;
    private int rowCount = 0;

    public ResultSetInvocationHandler(ResultSet delegate, HibernateReturningResult<?> returningResult) {
        this.delegate = delegate;
        this.returningResult = returningResult;
        this.calculateRowCount = returningResult != null;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.calculateRowCount) {
            if ("next".equals(method.getName())) {
                Object result = method.invoke((Object)this.delegate, args);
                if (((Boolean)result).booleanValue()) {
                    ++this.rowCount;
                }
                return result;
            }
            if ("close".equals(method.getName())) {
                this.returningResult.setUpdateCount(this.rowCount);
            }
        }
        return method.invoke((Object)this.delegate, args);
    }
}

