/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate.base.function;

import com.blazebit.persistence.integration.hibernate.base.HibernateAccessUtils;
import com.blazebit.persistence.integration.hibernate.base.function.HibernateJpqlFunctionAdapter;
import com.blazebit.persistence.integration.hibernate.base.function.HibernateSqmFunctionDescriptorAdapter;
import com.blazebit.persistence.spi.EntityManagerFactoryIntegrator;
import com.blazebit.persistence.spi.JpqlFunction;
import com.blazebit.persistence.spi.JpqlFunctionGroup;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.hibernate.Session;
import org.hibernate.dialect.AbstractHANADialect;
import org.hibernate.dialect.CockroachDialect;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DB2iDialect;
import org.hibernate.dialect.DB2zDialect;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.MariaDBDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.SpannerDialect;
import org.hibernate.dialect.SybaseDialect;
import org.hibernate.dialect.TiDBDialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.type.BasicType;

public abstract class AbstractHibernateEntityManagerFactoryIntegrator
implements EntityManagerFactoryIntegrator {
    private static final Logger LOG = Logger.getLogger(EntityManagerFactoryIntegrator.class.getName());
    private static final Set<String> NATIVE_WINDOW_FUNCTIONS = new HashSet<String>(Arrays.asList("listagg", "every", "row_number", "rank", "dense_rank", "percentile_cont", "percentile_disc", "percent_rank", "lag", "lead", "last_value", "first_value", "nth_value", "mode", "cume_dist"));
    private static final Set<String> FUNCTIONS_TO_SKIP = new HashSet<String>(Arrays.asList("concat"));

    protected String getDbmsName(Dialect dialect) {
        if (dialect instanceof MariaDBDialect) {
            return "mariadb";
        }
        if (dialect instanceof TiDBDialect) {
            return "tidb";
        }
        if (dialect instanceof MySQLDialect) {
            if (((MySQLDialect)dialect).getMySQLVersion().isSameOrAfter(8)) {
                return "mysql8";
            }
            return "mysql";
        }
        if (dialect instanceof CockroachDialect) {
            return "cockroach";
        }
        if (dialect instanceof DB2iDialect) {
            return "db2i";
        }
        if (dialect instanceof DB2zDialect) {
            return "db2z";
        }
        if (dialect instanceof DB2Dialect) {
            return "db2";
        }
        if (dialect instanceof AbstractHANADialect) {
            return "hana";
        }
        if (dialect instanceof SpannerDialect) {
            return "spanner";
        }
        if (dialect instanceof PostgreSQLDialect) {
            return "postgresql";
        }
        if (dialect instanceof OracleDialect) {
            return "oracle";
        }
        if (dialect instanceof SQLServerDialect) {
            return "microsoft";
        }
        if (dialect instanceof SybaseDialect) {
            return "sybase";
        }
        if (dialect instanceof H2Dialect) {
            return "h2";
        }
        if (dialect instanceof DerbyDialect) {
            return "derby";
        }
        if (dialect instanceof HSQLDialect) {
            return "hsql";
        }
        switch (dialect.getClass().getSimpleName()) {
            case "CUBRIDDialect": {
                return "cubrid";
            }
            case "InformixDialect": {
                return "informix";
            }
            case "IngresDialect": {
                return "ingres";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory registerFunctions(EntityManagerFactory entityManagerFactory, Map<String, JpqlFunctionGroup> dbmsFunctions) {
        try (EntityManager em = null;){
            em = entityManagerFactory.createEntityManager();
            Session s = (Session)em.unwrap(Session.class);
            SessionFactoryImplementor sfi = (SessionFactoryImplementor)s.getSessionFactory();
            SqmFunctionRegistry sqmFunctionRegistry = HibernateAccessUtils.getSqmFunctionRegistry(sfi);
            Dialect dialect = this.getDialect(s);
            String dbms = this.getDbmsName(dialect);
            for (Map.Entry<String, JpqlFunctionGroup> functionEntry : dbmsFunctions.entrySet()) {
                String functionName = functionEntry.getKey();
                JpqlFunctionGroup dbmsFunctionMap = functionEntry.getValue();
                if (NATIVE_WINDOW_FUNCTIONS.contains(functionName) || FUNCTIONS_TO_SKIP.contains(functionName)) continue;
                if ("ntile".equals(functionName)) {
                    sqmFunctionRegistry.namedWindowDescriptorBuilder("ntile").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant((BasicType)sfi.getTypeConfiguration().getBasicTypeForJavaType(Integer.class))).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.invariant((FunctionParameterType[])new FunctionParameterType[]{FunctionParameterType.INTEGER})).setArgumentsValidator((ArgumentsValidator)new ArgumentTypesValidator(StandardArgumentsValidators.exactly((int)1), new FunctionParameterType[]{FunctionParameterType.INTEGER})).register();
                    continue;
                }
                JpqlFunction function = dbmsFunctionMap.get(dbms);
                if (function == null && !dbmsFunctionMap.contains(dbms)) {
                    function = dbmsFunctionMap.get(null);
                }
                if (function == null) {
                    LOG.warning("Could not register the function '" + functionName + "' because there is neither an implementation for the dbms '" + dbms + "' nor a default implementation!");
                    continue;
                }
                sqmFunctionRegistry.register(functionName, (SqmFunctionDescriptor)new HibernateJpqlFunctionAdapter(sfi, dbmsFunctionMap.getKind(), function));
            }
            EntityManagerFactory entityManagerFactory2 = entityManagerFactory;
            return entityManagerFactory2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, JpqlFunction> getRegisteredFunctions(EntityManagerFactory entityManagerFactory) {
        try (EntityManager em = null;){
            em = entityManagerFactory.createEntityManager();
            Session s = (Session)em.unwrap(Session.class);
            SessionFactoryImplementor sf = (SessionFactoryImplementor)s.getSessionFactory();
            HashMap<String, JpqlFunction> map = new HashMap<String, JpqlFunction>();
            HibernateAccessUtils.getSqmFunctionRegistry(sf).getFunctionsByName().forEach(entry -> {
                SqmFunctionDescriptor function = (SqmFunctionDescriptor)entry.getValue();
                if (function instanceof HibernateJpqlFunctionAdapter) {
                    map.put((String)entry.getKey(), ((HibernateJpqlFunctionAdapter)function).unwrap());
                } else {
                    map.put((String)entry.getKey(), new HibernateSqmFunctionDescriptorAdapter(sf, (SqmFunctionDescriptor)entry.getValue()));
                }
            });
            HashMap<String, JpqlFunction> hashMap = map;
            return hashMap;
        }
    }

    protected Dialect getDialect(Session s) {
        SessionFactoryImplementor sf = (SessionFactoryImplementor)s.getSessionFactory();
        return sf.getJdbcServices().getDialect();
    }
}

