/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate.base.function;

import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;
import jakarta.persistence.metamodel.Type;
import java.util.ArrayList;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.SqmVisitableNode;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.type.descriptor.java.JavaType;

public class HibernateSqmFunctionDescriptorAdapter
implements JpqlFunction {
    private final SessionFactoryImplementor sfi;
    private final SqmFunctionDescriptor function;

    public HibernateSqmFunctionDescriptorAdapter(SessionFactoryImplementor sfi, SqmFunctionDescriptor function) {
        this.sfi = sfi;
        this.function = function;
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Class<?> getReturnType(final Class<?> firstArgumentType) {
        ReturnableType returnableType;
        if (firstArgumentType == null) {
            return null;
        }
        Object type = this.sfi.getTypeConfiguration().getBasicTypeForJavaType(firstArgumentType);
        if (type == null) {
            final JavaType javaType = this.sfi.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(firstArgumentType);
            type = new ReturnableType<Object>(){

                public JavaType<Object> getExpressibleJavaType() {
                    return javaType;
                }

                public Class<Object> getBindableJavaType() {
                    return firstArgumentType;
                }

                public Type.PersistenceType getPersistenceType() {
                    return Type.PersistenceType.BASIC;
                }

                public Class<Object> getJavaType() {
                    return firstArgumentType;
                }
            };
        }
        ArrayList arguments = new ArrayList(1);
        arguments.add(new CustomSqmTypedNode((SqmExpressible)type));
        if (this.function instanceof AbstractSqmFunctionDescriptor && (returnableType = ((AbstractSqmFunctionDescriptor)this.function).getReturnTypeResolver().resolveFunctionReturnType(null, arguments, this.sfi.getTypeConfiguration())) != null) {
            return returnableType.getBindableJavaType();
        }
        SqmExpressible expressionType = this.function.generateSqmExpression(arguments, null, this.sfi.getQueryEngine(), this.sfi.getTypeConfiguration()).getNodeType();
        return expressionType == null ? null : expressionType.getBindableJavaType();
    }

    public void render(FunctionRenderContext context) {
        throw new UnsupportedOperationException("Rendering functions through this API is not possible!");
    }

    private static class CustomSqmTypedNode<T>
    implements SqmTypedNode<T>,
    SqmVisitableNode {
        private final SqmExpressible<T> type;

        private CustomSqmTypedNode(SqmExpressible<T> type) {
            this.type = type;
        }

        public <X> X accept(SemanticQueryWalker<X> walker) {
            return (X)new QueryLiteral(null, (BasicValuedMapping)this.type);
        }

        public SqmTypedNode<T> copy(SqmCopyContext context) {
            return this;
        }

        public SqmExpressible<T> getNodeType() {
            return this.type;
        }

        public NodeBuilder nodeBuilder() {
            return null;
        }

        public void appendHqlString(StringBuilder sb) {
        }
    }
}

