/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.jackson;

import com.blazebit.persistence.integration.jackson.EntityViewIdValueAccessor;
import com.blazebit.persistence.integration.jackson.EntityViewReferenceDeserializer;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.ViewMetamodel;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;

public class EntityViewAwareObjectMapper {
    private final EntityViewManager entityViewManager;
    private final ObjectMapper objectMapper;

    public EntityViewAwareObjectMapper(EntityViewManager entityViewManager, ObjectMapper objectMapper) {
        this(entityViewManager, objectMapper, null);
    }

    public EntityViewAwareObjectMapper(final EntityViewManager entityViewManager, final ObjectMapper objectMapper, final EntityViewIdValueAccessor entityViewIdValueAccessor) {
        this.entityViewManager = entityViewManager;
        SimpleModule module = new SimpleModule();
        module.setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                ManagedViewType view = entityViewManager.getMetamodel().managedView(beanDesc.getBeanClass());
                if (view != null) {
                    return new EntityViewReferenceDeserializer(entityViewManager, view, objectMapper, beanDesc.getIgnoredPropertyNames(), entityViewIdValueAccessor);
                }
                return deserializer;
            }
        });
        objectMapper.registerModule((Module)module);
        objectMapper.configure(MapperFeature.INFER_PROPERTY_MUTATORS, false);
        objectMapper.configure(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS, false);
        objectMapper.setVisibility((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.DEFAULT){

            public boolean isSetterVisible(Method m) {
                if (super.isSetterVisible(m)) {
                    Class<?> rawParameterType = m.getParameterTypes()[0];
                    if (Collection.class.isAssignableFrom(rawParameterType) || Map.class.isAssignableFrom(rawParameterType)) {
                        return this.isCollectionSetterVisible(m.getDeclaringClass(), m.getName());
                    }
                    return true;
                }
                return false;
            }

            private boolean isCollectionSetterVisible(Class<?> declaringClass, String setterName) {
                String attributeName;
                MethodAttribute attribute;
                ViewMetamodel metamodel = entityViewManager.getMetamodel();
                ManagedViewType managedViewType = metamodel.managedView(declaringClass);
                if (managedViewType == null) {
                    ManagedViewType managedViewTypeSuper;
                    Class<?> superclass = declaringClass.getSuperclass();
                    if (superclass != Object.class && (managedViewTypeSuper = metamodel.managedView(superclass)) != null) {
                        managedViewType = managedViewTypeSuper;
                    }
                    if (managedViewType == null) {
                        for (Class<?> interfaceClass : declaringClass.getInterfaces()) {
                            ManagedViewType managedViewTypeInterface = metamodel.managedView(interfaceClass);
                            if (managedViewTypeInterface == null) continue;
                            managedViewType = managedViewTypeInterface;
                            break;
                        }
                    }
                    if (managedViewType == null) {
                        return true;
                    }
                }
                return (attribute = managedViewType.getAttribute(attributeName = Character.toLowerCase(setterName.charAt(3)) + setterName.substring(4))) == null || !attribute.isCollection();
            }
        });
        this.objectMapper = objectMapper;
    }

    public EntityViewManager getEntityViewManager() {
        return this.entityViewManager;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public boolean canRead(Class<?> clazz) {
        return this.entityViewManager.getMetamodel().managedView(clazz) != null;
    }

    public boolean canRead(JavaType javaType) {
        if (!javaType.isContainerType()) {
            return this.canRead(javaType.getRawClass());
        }
        if (javaType.isCollectionLikeType()) {
            return this.canRead(javaType.getContentType().getRawClass());
        }
        return false;
    }

    public ObjectReader readerFor(JavaType javaType) {
        if (Collection.class.isAssignableFrom(javaType.getRawClass())) {
            return this.objectMapper.readerFor(javaType);
        }
        return this.readerFor(javaType.getRawClass());
    }

    public ObjectReader readerFor(Class<?> type) {
        return this.objectMapper.readerFor(type);
    }
}

