/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.jackson;

import com.blazebit.persistence.integration.jackson.EntityViewIdValueAccessor;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.ViewType;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Set;

public class EntityViewReferenceDeserializer
extends JsonDeserializer {
    private final EntityViewManager entityViewManager;
    private final EntityViewIdValueAccessor entityViewIdValueAccessor;
    private final Class<?> entityViewClass;
    private final MethodAttribute<?, ?> idAttribute;
    private final JavaType idType;
    private final boolean deserializeIdFromJson;
    private final boolean updatable;
    private final boolean creatable;

    public EntityViewReferenceDeserializer(EntityViewManager entityViewManager, ManagedViewType<?> view, ObjectMapper objectMapper, Set<String> ignoredProperties, EntityViewIdValueAccessor entityViewIdValueAccessor) {
        this.entityViewManager = entityViewManager;
        this.entityViewClass = view.getJavaType();
        this.entityViewIdValueAccessor = entityViewIdValueAccessor;
        if (view instanceof ViewType) {
            MethodAttribute idAttribute = ((ViewType)view).getIdAttribute();
            this.deserializeIdFromJson = !ignoredProperties.contains(idAttribute.getName());
            this.idAttribute = idAttribute;
            JavaType idType = objectMapper.getTypeFactory().constructType((Type)this.idAttribute.getConvertedJavaType());
            if (!objectMapper.canDeserialize(idType)) {
                throw new IllegalArgumentException("Can't create entity view reference deserializer for entity view '" + this.entityViewClass.getName() + "' because id attribute '" + this.idAttribute.getName() + "' has an unsupported id type: " + this.idAttribute.getJavaType().getName());
            }
            this.idType = idType;
        } else {
            this.idAttribute = null;
            this.idType = null;
            this.deserializeIdFromJson = false;
        }
        this.updatable = view.isUpdatable();
        this.creatable = view.isCreatable();
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object reference = null;
        ObjectCodec codec = jsonParser.getCodec();
        JsonNode treeNode = (JsonNode)codec.readTree(jsonParser);
        Object id = this.retrieveId(jsonParser, codec, treeNode, !this.creatable || this.updatable);
        if (this.creatable && (!this.updatable || id == null)) {
            reference = this.entityViewManager.create(this.entityViewClass);
        } else if (id != null) {
            reference = this.entityViewManager.getReference(this.entityViewClass, id);
        }
        if (reference == null) {
            return null;
        }
        jsonParser = codec.treeAsTokens((TreeNode)treeNode);
        jsonParser.nextToken();
        return deserializationContext.findNonContextualValueDeserializer(deserializationContext.constructType(reference.getClass())).deserialize(jsonParser, deserializationContext, reference);
    }

    private Object retrieveId(JsonParser rootJsonParser, ObjectCodec codec, JsonNode treeNode, boolean consume) throws IOException {
        Object id;
        if (this.idAttribute == null || this.idType == null) {
            id = null;
        } else {
            JsonNode jsonNode;
            String idAttributeName = this.idAttribute.getName();
            if (this.deserializeIdFromJson && (jsonNode = treeNode.get(idAttributeName)) != null) {
                if (jsonNode.isNull()) {
                    id = null;
                } else {
                    id = codec.readValue(codec.treeAsTokens((TreeNode)jsonNode), (ResolvedType)this.idType);
                    if (consume) {
                        ((ObjectNode)treeNode).without(idAttributeName);
                    }
                }
            } else {
                id = rootJsonParser.getParsingContext().inRoot() && this.entityViewIdValueAccessor != null ? (Object)this.entityViewIdValueAccessor.getValue(rootJsonParser, this.idType.getRawClass()) : null;
            }
        }
        return id;
    }
}

