/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.jaxrs.jackson;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.integration.jackson.EntityViewAwareObjectMapper;
import com.blazebit.persistence.integration.jackson.EntityViewIdValueAccessor;
import com.blazebit.persistence.integration.jaxrs.EntityViewId;
import com.blazebit.persistence.view.ConvertOperationBuilder;
import com.blazebit.persistence.view.ConvertOption;
import com.blazebit.persistence.view.EntityViewBuilder;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.EntityViewSetting;
import com.blazebit.persistence.view.FlushOperationBuilder;
import com.blazebit.persistence.view.change.SingularChangeModel;
import com.blazebit.persistence.view.metamodel.ViewMetamodel;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Priority(value=4999)
@Provider
@Consumes(value={"application/json", "application/*+json", "text/json", "*/*"})
public class EntityViewMessageBodyReader
implements MessageBodyReader<Object> {
    private static final ParamConverterProvider FROM_STRING_PARAM_CONVERTER_PROVIDER = new FromStringParamConverterProvider();
    @Inject
    private Instance<EntityViewManager> entityViewManager;
    @Inject
    private Instance<ObjectMapper> objectMapper;
    @Inject
    @Any
    private Instance<ParamConverterProvider> paramConverterProviders;
    @Context
    private UriInfo uriInfo;
    @Context
    private Providers providers;
    private EntityViewAwareObjectMapper entityViewAwareObjectMapper;
    private final ThreadLocal<String> idValueHolder = new ThreadLocal();

    @PostConstruct
    public void init() {
        if (this.entityViewManager.isUnsatisfied()) {
            this.entityViewAwareObjectMapper = null;
        } else {
            ContextResolver resolver;
            ObjectMapper mapper = null;
            if (this.providers != null && (resolver = this.providers.getContextResolver(ObjectMapper.class, MediaType.APPLICATION_JSON_TYPE)) != null) {
                mapper = (ObjectMapper)resolver.getContext(EntityViewMessageBodyReader.class);
            }
            if (mapper == null) {
                mapper = this.objectMapper.isUnsatisfied() ? new ObjectMapper() : (ObjectMapper)this.objectMapper.get();
            }
            this.entityViewAwareObjectMapper = new EntityViewAwareObjectMapper((EntityViewManager)new LazyEntityViewManager(), mapper, new EntityViewIdValueAccessor(){

                public <T> T getValue(JsonParser jsonParser, Class<T> idType) {
                    ParamConverterProvider paramConverterProvider;
                    String value = (String)EntityViewMessageBodyReader.this.idValueHolder.get();
                    if (value == null || String.class.equals(idType)) {
                        return (T)value;
                    }
                    ParamConverter paramConverter = null;
                    Iterator iterator = EntityViewMessageBodyReader.this.paramConverterProviders.iterator();
                    while (iterator.hasNext() && (paramConverter = (paramConverterProvider = (ParamConverterProvider)iterator.next()).getConverter(idType, idType, null)) == null) {
                    }
                    if (paramConverter == null) {
                        paramConverter = FROM_STRING_PARAM_CONVERTER_PROVIDER.getConverter(idType, idType, null);
                    }
                    if (paramConverter == null) {
                        throw new RuntimeException("No " + ParamConverter.class.getName() + " could be found to convert to type " + idType.getName());
                    }
                    return (T)paramConverter.fromString(value);
                }
            });
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !this.entityViewManager.isUnsatisfied() && ((EntityViewManager)this.entityViewManager.get()).getMetamodel().view(type) != null && this.hasMatchingMediaType(mediaType) && !InputStream.class.isAssignableFrom(type) && !Reader.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        EntityViewId entityViewAnnotation = null;
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(EntityViewId.class)) continue;
            entityViewAnnotation = (EntityViewId)annotation;
            break;
        }
        if (entityViewAnnotation != null) {
            String pathVariableName;
            String string = pathVariableName = entityViewAnnotation.value().isEmpty() ? entityViewAnnotation.name() : entityViewAnnotation.value();
            if (pathVariableName.isEmpty()) {
                throw new IllegalArgumentException("Entity view id path param name for argument type [" + type.getName() + "] not available.");
            }
            String pathVariableStringValue = (String)this.uriInfo.getPathParameters().getFirst((Object)pathVariableName);
            this.idValueHolder.set(pathVariableStringValue);
        }
        try {
            if (this.entityViewAwareObjectMapper != null && this.entityViewAwareObjectMapper.canRead(type)) {
                JavaType javaType = this.entityViewAwareObjectMapper.getObjectMapper().constructType(genericType);
                ObjectReader objectReader = this.entityViewAwareObjectMapper.readerFor(javaType);
                try {
                    Object object = objectReader.readValue(entityStream);
                    return object;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        finally {
            this.idValueHolder.remove();
        }
        return null;
    }

    private boolean hasMatchingMediaType(MediaType mediaType) {
        if (mediaType != null) {
            String subtype = mediaType.getSubtype();
            return "json".equalsIgnoreCase(subtype) || subtype.endsWith("+json") || "javascript".equals(subtype) || "x-javascript".equals(subtype) || "x-json".equals(subtype);
        }
        return true;
    }

    private final class LazyEntityViewManager
    implements EntityViewManager {
        private LazyEntityViewManager() {
        }

        public ViewMetamodel getMetamodel() {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).getMetamodel();
        }

        public Map<String, Object> getOptionalParameters() {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).getOptionalParameters();
        }

        public <T> T find(EntityManager entityManager, Class<T> entityViewClass, Object entityId) {
            return (T)((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).find(entityManager, entityViewClass, entityId);
        }

        public <T> T find(EntityManager entityManager, EntityViewSetting<T, CriteriaBuilder<T>> entityViewSetting, Object entityId) {
            return (T)((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).find(entityManager, entityViewSetting, entityId);
        }

        public <T> T getReference(Class<T> entityViewClass, Object id) {
            return (T)((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).getReference(entityViewClass, id);
        }

        public <T> T getEntityReference(EntityManager entityManager, Object entityView) {
            return (T)((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).getEntityReference(entityManager, entityView);
        }

        public <T> SingularChangeModel<T> getChangeModel(T entityView) {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).getChangeModel(entityView);
        }

        public <T> T create(Class<T> entityViewClass) {
            return (T)((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).create(entityViewClass);
        }

        public <T> T create(Class<T> entityViewClass, Map<String, Object> optionalParameters) {
            return (T)((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).create(entityViewClass, optionalParameters);
        }

        public <X> EntityViewBuilder<X> createBuilder(Class<X> clazz) {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).createBuilder(clazz);
        }

        public <X> EntityViewBuilder<X> createBuilder(Class<X> clazz, String constructorName) {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).createBuilder(clazz, constructorName);
        }

        public <X> EntityViewBuilder<X> createBuilder(X view) {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).createBuilder(view);
        }

        public <X> EntityViewBuilder<X> createBuilder(X view, String constructorName) {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).createBuilder(view, constructorName);
        }

        public <X> EntityViewBuilder<X> createBuilder(Class<X> clazz, Map<String, Object> optionalParameters) {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).createBuilder(clazz, optionalParameters);
        }

        public <X> EntityViewBuilder<X> createBuilder(Class<X> clazz, Map<String, Object> optionalParameters, String constructorName) {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).createBuilder(clazz, optionalParameters, constructorName);
        }

        public <X> EntityViewBuilder<X> createBuilder(X view, Map<String, Object> optionalParameters) {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).createBuilder(view, optionalParameters);
        }

        public <X> EntityViewBuilder<X> createBuilder(X view, Map<String, Object> optionalParameters, String constructorName) {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).createBuilder(view, optionalParameters, constructorName);
        }

        public <T> T convert(Object source, Class<T> entityViewClass, ConvertOption ... convertOptions) {
            return (T)((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).convert(source, entityViewClass, convertOptions);
        }

        public <T> T convert(Object source, Class<T> entityViewClass, String constructorName, ConvertOption ... convertOptions) {
            return (T)((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).convert(source, entityViewClass, constructorName, convertOptions);
        }

        public <T> T convert(Object source, Class<T> entityViewClass, Map<String, Object> optionalParameters, ConvertOption ... convertOptions) {
            return (T)((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).convert(source, entityViewClass, optionalParameters, convertOptions);
        }

        public <T> T convert(Object source, Class<T> entityViewClass, String constructorName, Map<String, Object> optionalParameters, ConvertOption ... convertOptions) {
            return (T)((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).convert(source, entityViewClass, constructorName, optionalParameters, convertOptions);
        }

        public <T> ConvertOperationBuilder<T> convertWith(Object source, Class<T> entityViewClass, ConvertOption ... convertOptions) {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).convertWith(source, entityViewClass, convertOptions);
        }

        public <T> ConvertOperationBuilder<T> convertWith(Object source, Class<T> entityViewClass, String constructorName, ConvertOption ... convertOptions) {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).convertWith(source, entityViewClass, constructorName, convertOptions);
        }

        public <T> ConvertOperationBuilder<T> convertWith(Object source, Class<T> entityViewClass, Map<String, Object> optionalParameters, ConvertOption ... convertOptions) {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).convertWith(source, entityViewClass, optionalParameters, convertOptions);
        }

        public <T> ConvertOperationBuilder<T> convertWith(Object source, Class<T> entityViewClass, String constructorName, Map<String, Object> optionalParameters, ConvertOption ... convertOptions) {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).convertWith(source, entityViewClass, constructorName, optionalParameters, convertOptions);
        }

        public void save(EntityManager entityManager, Object view) {
            ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).save(entityManager, view);
        }

        public void saveFull(EntityManager entityManager, Object view) {
            ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).saveFull(entityManager, view);
        }

        public void saveTo(EntityManager entityManager, Object view, Object entity) {
            ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).saveTo(entityManager, view, entity);
        }

        public void saveFullTo(EntityManager entityManager, Object view, Object entity) {
            ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).saveFullTo(entityManager, view, entity);
        }

        @Deprecated
        public void update(EntityManager entityManager, Object view) {
            ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).update(entityManager, view);
        }

        @Deprecated
        public void updateFull(EntityManager entityManager, Object view) {
            ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).updateFull(entityManager, view);
        }

        public FlushOperationBuilder saveWith(EntityManager entityManager, Object view) {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).saveWith(entityManager, view);
        }

        public FlushOperationBuilder saveFullWith(EntityManager entityManager, Object view) {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).saveFullWith(entityManager, view);
        }

        public FlushOperationBuilder saveWithTo(EntityManager entityManager, Object view, Object entity) {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).saveWithTo(entityManager, view, entity);
        }

        public FlushOperationBuilder saveFullWithTo(EntityManager entityManager, Object view, Object entity) {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).saveFullWithTo(entityManager, view, entity);
        }

        public void remove(EntityManager entityManager, Object view) {
            ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).remove(entityManager, view);
        }

        public FlushOperationBuilder removeWith(EntityManager entityManager, Object view) {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).removeWith(entityManager, view);
        }

        public void remove(EntityManager entityManager, Class<?> entityViewClass, Object viewId) {
            ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).remove(entityManager, entityViewClass, viewId);
        }

        public FlushOperationBuilder removeWith(EntityManager entityManager, Class<?> entityViewClass, Object viewId) {
            return ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).removeWith(entityManager, entityViewClass, viewId);
        }

        public <T, Q extends FullQueryBuilder<T, Q>> Q applySetting(EntityViewSetting<T, Q> setting, CriteriaBuilder<?> criteriaBuilder) {
            return (Q)((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).applySetting(setting, criteriaBuilder);
        }

        public <T, Q extends FullQueryBuilder<T, Q>> Q applySetting(EntityViewSetting<T, Q> setting, CriteriaBuilder<?> criteriaBuilder, String entityViewRoot) {
            return (Q)((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).applySetting(setting, criteriaBuilder, entityViewRoot);
        }

        public <T> T getService(Class<T> serviceClass) {
            return (T)((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).getService(serviceClass);
        }

        public void close() {
            ((EntityViewManager)EntityViewMessageBodyReader.this.entityViewManager.get()).close();
        }
    }

    private static class FromStringParamConverterProvider
    implements ParamConverterProvider {
        private static final Map<Class<?>, ParamConverter<?>> CACHED_PARAM_CONVERTERS = new ConcurrentHashMap();

        private FromStringParamConverterProvider() {
        }

        public <T> ParamConverter<T> getConverter(Class<T> clazz, Type type, Annotation[] annotations) {
            Object converter = CACHED_PARAM_CONVERTERS.get(clazz);
            if (converter == null) {
                Class effectiveClass = Short.TYPE.equals(clazz) ? Short.class : (Integer.TYPE.equals(clazz) ? Integer.class : (Long.TYPE.equals(clazz) ? Long.class : (Float.TYPE.equals(clazz) ? Float.class : (Double.TYPE.equals(clazz) ? Double.class : (Boolean.TYPE.equals(clazz) ? Boolean.class : (Byte.TYPE.equals(clazz) ? Byte.class : (Character.TYPE.equals(clazz) ? Character.class : clazz)))))));
                Method fromStringMethod = null;
                try {
                    fromStringMethod = effectiveClass.getMethod("fromString", String.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                Method valueOfMethod = null;
                try {
                    valueOfMethod = effectiveClass.getMethod("valueOf", String.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                Method effectiveMethod = fromStringMethod != null && valueOfMethod != null ? (effectiveClass.isEnum() ? fromStringMethod : valueOfMethod) : (fromStringMethod != null ? fromStringMethod : valueOfMethod);
                if (effectiveClass == Character.class) {
                    converter = new CharacterParamConverter();
                } else if (effectiveMethod == null) {
                    Constructor constructor = null;
                    try {
                        constructor = effectiveClass.getConstructor(String.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    converter = constructor == null ? null : new ConstructorBasedParamConverter(constructor);
                } else {
                    converter = new MethodBasedParamConverter(effectiveMethod);
                }
                if (converter != null) {
                    CACHED_PARAM_CONVERTERS.put(clazz, (ParamConverter<?>)converter);
                }
            }
            return converter;
        }

        private static class CharacterParamConverter
        implements ParamConverter<Character> {
            private CharacterParamConverter() {
            }

            public Character fromString(String s) {
                Character c = s == null || s.length() > 1 ? null : Character.valueOf(s.charAt(0));
                return c;
            }

            public String toString(Character o) {
                return o.toString();
            }
        }

        private static class ConstructorBasedParamConverter<T>
        implements ParamConverter<T> {
            private final Constructor<T> stringConstructor;

            public ConstructorBasedParamConverter(Constructor<T> stringConstructor) {
                this.stringConstructor = stringConstructor;
            }

            public T fromString(String s) {
                try {
                    return this.stringConstructor.newInstance(s);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new BadRequestException("Malformed input: " + s);
                }
            }

            public String toString(T o) {
                return o.toString();
            }
        }

        private static class MethodBasedParamConverter<T>
        implements ParamConverter<T> {
            private final Method stringConsumingMethod;

            public MethodBasedParamConverter(Method stringConsumingMethod) {
                this.stringConsumingMethod = stringConsumingMethod;
            }

            public T fromString(String s) {
                try {
                    return (T)this.stringConsumingMethod.invoke(null, s);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new BadRequestException("Malformed input: " + s);
                }
            }

            public String toString(T o) {
                return o.toString();
            }
        }
    }
}

