/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.jpa;

import com.blazebit.persistence.parser.ListIndexAttribute;
import com.blazebit.persistence.parser.MapKeyAttribute;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.AttributePath;
import com.blazebit.persistence.spi.JpaMetamodelAccessor;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class JpaMetamodelAccessorImpl
implements JpaMetamodelAccessor {
    public static final JpaMetamodelAccessorImpl INSTANCE = new JpaMetamodelAccessorImpl();

    protected JpaMetamodelAccessorImpl() {
    }

    public AttributePath getAttributePath(Metamodel metamodel, ManagedType<?> type, String attributePath) {
        if (attributePath.indexOf(46) == -1) {
            ArrayList<Attribute> attrPath = new ArrayList<Attribute>(1);
            Attribute attribute = type.getAttribute(attributePath);
            if (attribute == null) {
                throw new IllegalArgumentException("Attribute '" + attributePath + "' does not exist on '" + JpaMetamodelUtils.getTypeName(type) + "'!");
            }
            attrPath.add(attribute);
            return new AttributePath(attrPath, JpaMetamodelUtils.resolveFieldClass((Class)type.getJavaType(), (Attribute)attribute));
        }
        ArrayList<Attribute> attrPath = new ArrayList<Attribute>();
        String[] attributeParts = attributePath.split("\\.");
        Object currentType = type;
        Class currentClass = type.getJavaType();
        for (int i = 0; i < attributeParts.length; ++i) {
            PluralAttribute pluralAttr;
            Type elementType;
            Attribute attr = null;
            if (currentType == null) break;
            attr = JpaMetamodelUtils.getAttribute(currentType, (String)attributeParts[i]);
            if (attr == null) {
                attrPath.clear();
                break;
            }
            currentClass = JpaMetamodelUtils.resolveFieldClass((Class)currentClass, (Attribute)attr);
            currentType = attr instanceof PluralAttribute ? ((elementType = (pluralAttr = (PluralAttribute)attr).getElementType()).getPersistenceType() == Type.PersistenceType.EMBEDDABLE ? metamodel.embeddable(currentClass) : (elementType.getPersistenceType() == Type.PersistenceType.BASIC ? null : metamodel.entity(currentClass))) : (attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED ? metamodel.embeddable(currentClass) : (attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.BASIC ? null : metamodel.entity(currentClass)));
            attrPath.add(attr);
        }
        if (attrPath.isEmpty()) {
            throw new IllegalArgumentException("Path " + attributePath + " does not exist on entity " + JpaMetamodelUtils.getTypeName(type));
        }
        return new AttributePath(attrPath, currentClass);
    }

    public AttributePath getBasicAttributePath(Metamodel metamodel, ManagedType<?> type, String attributePath) {
        if (attributePath.indexOf(46) == -1) {
            ArrayList<Attribute> attrPath = new ArrayList<Attribute>(1);
            Attribute attribute = type.getAttribute(attributePath);
            if (attribute == null) {
                throw new IllegalArgumentException("Attribute '" + attributePath + "' does not exist on '" + JpaMetamodelUtils.getTypeName(type) + "'!");
            }
            attrPath.add(attribute);
            return new AttributePath(attrPath, JpaMetamodelUtils.resolveFieldClass((Class)type.getJavaType(), (Attribute)attribute));
        }
        ArrayList<Attribute> attrPath = new ArrayList<Attribute>();
        String[] attributeParts = attributePath.split("\\.");
        EmbeddableType currentType = type;
        Class currentClass = type.getJavaType();
        boolean joinableAllowed = true;
        for (int i = 0; i < attributeParts.length; ++i) {
            Attribute attr = null;
            if (currentType == null) break;
            attr = JpaMetamodelUtils.getAttribute(currentType, (String)attributeParts[i]);
            if (attr == null) {
                attrPath.clear();
                break;
            }
            currentClass = JpaMetamodelUtils.resolveFieldClass((Class)currentClass, (Attribute)attr);
            if (attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED) {
                currentType = metamodel.embeddable(currentClass);
            } else if (attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.BASIC) {
                currentType = null;
            } else if (this.isJoinable(attr) && joinableAllowed) {
                joinableAllowed = false;
                if (i + 1 < attributeParts.length) {
                    currentType = metamodel.entity(currentClass);
                    Attribute nextAttr = JpaMetamodelUtils.getAttribute((ManagedType)currentType, (String)attributeParts[i + 1]);
                    if (!JpaMetamodelUtils.getSingleIdAttribute((IdentifiableType)((EntityType)currentType)).getName().equals(nextAttr.getName())) {
                        throw new IllegalArgumentException("Path joining not allowed in returning expression: " + attributePath);
                    }
                }
            } else {
                throw new IllegalArgumentException("Path joining not allowed in returning expression: " + attributePath);
            }
            attrPath.add(attr);
        }
        if (attrPath.isEmpty()) {
            throw new IllegalArgumentException("Path " + attributePath + " does not exist on entity " + JpaMetamodelUtils.getTypeName(type));
        }
        return new AttributePath(attrPath, currentClass);
    }

    public AttributePath getJoinTableCollectionAttributePath(Metamodel metamodel, EntityType<?> type, String attributePath, String collectionName) {
        ListIndexAttribute collectionFunction;
        int collectionArgumentStart;
        String trimmedPath = attributePath.trim();
        String indexStart = "index(";
        String keyStart = "key(";
        if (trimmedPath.regionMatches(true, 0, indexStart, 0, indexStart.length())) {
            collectionArgumentStart = indexStart.length();
            collectionFunction = new ListIndexAttribute(type.getList(collectionName));
        } else if (trimmedPath.regionMatches(true, 0, keyStart, 0, keyStart.length())) {
            collectionArgumentStart = keyStart.length();
            collectionFunction = new MapKeyAttribute(type.getMap(collectionName));
        } else {
            int dotIndex = trimmedPath.indexOf(46);
            if (!(trimmedPath.equals(collectionName) || dotIndex != -1 && trimmedPath.substring(0, dotIndex).equals(collectionName))) {
                SingularAttribute idAttribute = JpaMetamodelUtils.getSingleIdAttribute(type);
                if (!idAttribute.getName().equals(attributePath)) {
                    throw new IllegalArgumentException("Only access to the owner type's id attribute '" + idAttribute.getName() + "' is allowed. Invalid access to different attribute through the expression: " + attributePath);
                }
                return new AttributePath(new ArrayList<SingularAttribute>(Collections.singletonList(idAttribute)), JpaMetamodelUtils.resolveFieldClass((Class)type.getJavaType(), (Attribute)idAttribute));
            }
            Attribute collectionAttribute = JpaMetamodelUtils.getAttribute(type, (String)collectionName);
            Class targetClass = JpaMetamodelUtils.resolveFieldClass((Class)type.getJavaType(), (Attribute)collectionAttribute);
            if (dotIndex == -1) {
                return new AttributePath(new ArrayList<Attribute>(Collections.singletonList(collectionAttribute)), targetClass);
            }
            String collectionElementAttributeName = trimmedPath.substring(dotIndex + 1);
            ManagedType targetManagedType = metamodel.managedType(targetClass);
            if (targetManagedType instanceof EntityType) {
                EntityType targetEntityType = (EntityType)targetManagedType;
                SingularAttribute idAttribute = JpaMetamodelUtils.getSingleIdAttribute((IdentifiableType)targetEntityType);
                String actualIdAttributeName = idAttribute.getName();
                if (!actualIdAttributeName.equals(collectionElementAttributeName)) {
                    throw new IllegalArgumentException("Only access to the target element type's id attribute '" + actualIdAttributeName + "' is allowed. Invalid access to different attribute through the expression: " + attributePath);
                }
                return new AttributePath(new ArrayList<Attribute>(Arrays.asList(collectionAttribute, idAttribute)), JpaMetamodelUtils.resolveFieldClass((Class)targetClass, (Attribute)idAttribute));
            }
            Attribute attribute = null;
            IllegalArgumentException cause = null;
            try {
                attribute = targetManagedType.getAttribute(collectionElementAttributeName);
            }
            catch (IllegalArgumentException ex) {
                cause = ex;
            }
            if (attribute == null) {
                throw new IllegalArgumentException("Couldn't find attribute '" + collectionElementAttributeName + "' on managed type '" + targetClass.getName() + "'. Invalid access through the expression: " + attributePath, cause);
            }
            return new AttributePath(new ArrayList<Attribute>(Arrays.asList(collectionAttribute, attribute)), JpaMetamodelUtils.resolveFieldClass((Class)targetClass, (Attribute)attribute));
        }
        String collectionAttributeName = trimmedPath.substring(collectionArgumentStart, trimmedPath.length() - 1);
        if (!collectionAttributeName.equals(collectionName)) {
            throw new IllegalArgumentException("Collection functions are only allowed to be used with the collection '" + collectionName + "'!. Invalid use in the expression: " + attributePath);
        }
        return new AttributePath(new ArrayList<ListIndexAttribute>(Collections.singletonList(collectionFunction)), collectionFunction.getJavaType());
    }

    public boolean isJoinable(Attribute<?, ?> attr) {
        return attr.isCollection() || attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE || attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE;
    }

    public boolean isCompositeNode(Attribute<?, ?> attr) {
        if (attr.isCollection()) {
            PluralAttribute pluralAttribute = (PluralAttribute)attr;
            return pluralAttribute.getElementType().getPersistenceType() != Type.PersistenceType.BASIC;
        }
        return attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE || attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE;
    }

    public boolean isElementCollection(Attribute<?, ?> attribute) {
        return attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
    }
}

