/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.quarkus.deployment;

import com.blazebit.persistence.impl.function.entity.ValuesEntity;
import com.blazebit.persistence.integration.quarkus.deployment.BlazePersistenceInstanceDescriptorBuildItem;
import com.blazebit.persistence.integration.quarkus.deployment.EntityViewJandexScavenger;
import com.blazebit.persistence.integration.quarkus.deployment.EntityViewListenersBuildItem;
import com.blazebit.persistence.integration.quarkus.deployment.EntityViewsBuildItem;
import com.blazebit.persistence.integration.quarkus.runtime.BlazePersistenceConfiguration;
import com.blazebit.persistence.integration.quarkus.runtime.BlazePersistenceInstance;
import com.blazebit.persistence.integration.quarkus.runtime.BlazePersistenceInstanceConfiguration;
import com.blazebit.persistence.integration.quarkus.runtime.BlazePersistenceInstanceUtil;
import com.blazebit.persistence.parser.expression.ConcurrentHashMapExpressionCache;
import com.blazebit.persistence.view.EntityView;
import com.blazebit.persistence.view.EntityViews;
import com.blazebit.persistence.view.spi.EntityViewConfiguration;
import com.blazebit.persistence.view.spi.EntityViewMapping;
import io.quarkus.builder.Version;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.hibernate.orm.deployment.AdditionalJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

class BlazePersistenceProcessor {
    static final String CAPABILITY = "com.blazebit.persistence.integration.quarkus";
    static final String FEATURE = "blaze-persistence";
    private static final Logger LOG = Logger.getLogger(BlazePersistenceProcessor.class);
    private static final DotName ENTITY_VIEW = DotName.createSimple((String)EntityView.class.getName());
    private static final DotName BLAZE_PERSISTENCE_INSTANCE = DotName.createSimple((String)BlazePersistenceInstance.class.getName());
    private static final DotName BLAZE_PERSISTENCE_INSTANCE_REPEATABLE_CONTAINER = DotName.createSimple((String)BlazePersistenceInstance.List.class.getName());

    BlazePersistenceProcessor() {
    }

    @BuildStep
    CapabilityBuildItem capability() {
        String version = Version.getVersion();
        int dotIndex = version.indexOf(46);
        if (dotIndex == -1 || Integer.parseInt(version.substring(0, dotIndex)) >= 2) {
            return null;
        }
        return new CapabilityBuildItem(CAPABILITY);
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalIndexedClassesBuildItem addBlazePersistenceInstanceAnnotationToIndex() {
        return new AdditionalIndexedClassesBuildItem(BlazePersistenceInstance.class.getName());
    }

    @BuildStep
    void addBlazePersistenceEntities(BuildProducer<AdditionalJpaModelBuildItem> jpaModelBuildItemBuildProducer) {
        Constructor<?> constructor = AdditionalJpaModelBuildItem.class.getDeclaredConstructors()[0];
        Object argument = constructor.getParameterTypes()[0] == Class.class ? ValuesEntity.class : ValuesEntity.class.getName();
        try {
            jpaModelBuildItemBuildProducer.produce((BuildItem)((AdditionalJpaModelBuildItem)constructor.newInstance(argument)));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not add ValuesEntity class to persistence unit!", e);
        }
    }

    @BuildStep
    void includeArchivesHostingEntityViewPackagesInIndex(BlazePersistenceConfiguration blazePersistenceConfig, BuildProducer<AdditionalApplicationArchiveMarkerBuildItem> additionalApplicationArchiveMarkers) {
        for (BlazePersistenceInstanceConfiguration blazePersistenceInstanceConfig : blazePersistenceConfig.blazePersistenceInstances().values()) {
            if (!blazePersistenceInstanceConfig.packages().isPresent()) continue;
            for (String pakkage : (Set)blazePersistenceInstanceConfig.packages().get()) {
                additionalApplicationArchiveMarkers.produce((BuildItem)new AdditionalApplicationArchiveMarkerBuildItem(pakkage.replace('.', '/')));
            }
        }
    }

    @BuildStep
    public EntityViewsBuildItem produceEntityViewsBuildItem(CombinedIndexBuildItem index) {
        EntityViewJandexScavenger entityViewJandexScavenger = new EntityViewJandexScavenger(index.getIndex());
        return entityViewJandexScavenger.discoverAndRegisterEntityViews();
    }

    @BuildStep
    public EntityViewListenersBuildItem produceEntityViewListenersBuildItem(CombinedIndexBuildItem index) {
        EntityViewJandexScavenger entityViewJandexScavenger = new EntityViewJandexScavenger(index.getIndex());
        return entityViewJandexScavenger.discoverAndRegisterEntityViewListeners();
    }

    @BuildStep
    void buildBlazePersistenceInstanceDescriptors(EntityViewsBuildItem entityViewsBuildItem, CombinedIndexBuildItem indexBuildItem, EntityViewListenersBuildItem entityViewListenersBuildItem, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, BlazePersistenceConfiguration blazePersistenceConfig, BuildProducer<BlazePersistenceInstanceDescriptorBuildItem> blazePersistenceDescriptorBuildItemProducer) {
        Set<String> entityViewListenerClassesForDefaultBlazePersistenceInstance;
        Set<String> entityViewClassesForDefaultBlazePersistenceInstance;
        Map<Object, Object> entityViewListenerClassesPerBlazePersistenceInstance;
        Map<Object, Object> entityViewClassesPerBlazePersistenceInstance;
        if (persistenceUnitDescriptors.isEmpty()) {
            LOG.warn((Object)"The Blaze-Persistence dependency is present but no persistence units have been defined.");
            return;
        }
        Optional<PersistenceUnitDescriptorBuildItem> defaultPersistenceUnit = persistenceUnitDescriptors.stream().filter(pu -> PersistenceUnitUtil.isDefaultPersistenceUnit((String)pu.getPersistenceUnitName())).findFirst();
        boolean enableDefaultBlazePersistence = defaultPersistenceUnit.isPresent() && blazePersistenceConfig.namedBlazePersistenceInstances().isEmpty() || blazePersistenceConfig.defaultBlazePersistenceInstance().isAnyPropertySet();
        boolean hasPackagesInQuarkusConfig = BlazePersistenceProcessor.hasPackagesInQuarkusConfig(blazePersistenceConfig);
        Collection<AnnotationInstance> packageLevelBlazePersistenceInstanceAnnotations = BlazePersistenceProcessor.getPackageLevelBlazePersistenceInstanceAnnotations(indexBuildItem.getIndex());
        if (enableDefaultBlazePersistence && blazePersistenceConfig.namedBlazePersistenceInstances().isEmpty() && !hasPackagesInQuarkusConfig && packageLevelBlazePersistenceInstanceAnnotations.isEmpty()) {
            entityViewClassesPerBlazePersistenceInstance = Collections.emptyMap();
            entityViewListenerClassesPerBlazePersistenceInstance = Collections.emptyMap();
            entityViewClassesForDefaultBlazePersistenceInstance = entityViewsBuildItem.getEntityViewClassNames();
            entityViewListenerClassesForDefaultBlazePersistenceInstance = entityViewListenersBuildItem.getEntityViewListenerClassNames();
        } else {
            Map<String, Set<String>> blazePersistenceInstanceToPackagesMapping = BlazePersistenceProcessor.mapBlazePersistenceInstancesToPackages(blazePersistenceConfig, enableDefaultBlazePersistence, hasPackagesInQuarkusConfig, packageLevelBlazePersistenceInstanceAnnotations);
            entityViewClassesPerBlazePersistenceInstance = BlazePersistenceProcessor.buildClassesToBlazePersistenceInstanceMapping(blazePersistenceInstanceToPackagesMapping, entityViewsBuildItem.getEntityViewClassNames(), indexBuildItem.getIndex());
            entityViewListenerClassesPerBlazePersistenceInstance = BlazePersistenceProcessor.buildClassesToBlazePersistenceInstanceMapping(blazePersistenceInstanceToPackagesMapping, entityViewListenersBuildItem.getEntityViewListenerClassNames(), indexBuildItem.getIndex());
            entityViewClassesForDefaultBlazePersistenceInstance = entityViewClassesPerBlazePersistenceInstance.getOrDefault("<default>", Collections.emptySet());
            entityViewListenerClassesForDefaultBlazePersistenceInstance = entityViewListenerClassesPerBlazePersistenceInstance.getOrDefault("<default>", Collections.emptySet());
        }
        if (enableDefaultBlazePersistence) {
            blazePersistenceDescriptorBuildItemProducer.produce((BuildItem)new BlazePersistenceInstanceDescriptorBuildItem("<default>", entityViewClassesForDefaultBlazePersistenceInstance, entityViewListenerClassesForDefaultBlazePersistenceInstance));
        } else if (!(blazePersistenceConfig.defaultBlazePersistenceInstance().persistenceUnit().isPresent() && !PersistenceUnitUtil.isDefaultPersistenceUnit((String)((String)blazePersistenceConfig.defaultBlazePersistenceInstance().persistenceUnit().get())) || defaultPersistenceUnit.isPresent())) {
            if (!entityViewClassesForDefaultBlazePersistenceInstance.isEmpty()) {
                LOG.warn((Object)"Entity view classes are defined for the default Blaze-Persistence instance but no default persistence unit found: the default Blaze-Persistence instance will not be created.");
            }
            if (!entityViewListenerClassesForDefaultBlazePersistenceInstance.isEmpty()) {
                LOG.warn((Object)"Entity view listener classes are defined for the default Blaze-Persistence instance but no default persistence unit found: the default Blaze-Persistence instance will not be created.");
            }
        }
        for (Map.Entry namedInstance : blazePersistenceConfig.namedBlazePersistenceInstances().entrySet()) {
            BlazePersistenceInstanceConfiguration blazePersistenceInstanceConfig = (BlazePersistenceInstanceConfiguration)namedInstance.getValue();
            if (blazePersistenceInstanceConfig.persistenceUnit().isPresent()) {
                persistenceUnitDescriptors.stream().filter(descriptor -> ((String)blazePersistenceInstanceConfig.persistenceUnit().get()).equals(descriptor.getPersistenceUnitName())).findFirst().orElseThrow(() -> new ConfigurationException(String.format("The persistence unit '%1$s' is not configured but the Blaze-Persistence instance '%2$s' uses it.", blazePersistenceInstanceConfig.persistenceUnit().get(), namedInstance.getKey())));
            } else {
                if (!BlazePersistenceInstanceUtil.isDefaultBlazePersistenceInstance((String)((String)namedInstance.getKey()))) {
                    throw new ConfigurationException(String.format("Persistence unit must be defined for Blaze-Persistence instance '%s'.", namedInstance.getKey()));
                }
                if (!defaultPersistenceUnit.isPresent()) {
                    throw new ConfigurationException(String.format("The default persistence unit is not configured but the Blaze-Persistence instance '%s' uses it.", namedInstance.getKey()));
                }
            }
            blazePersistenceDescriptorBuildItemProducer.produce((BuildItem)new BlazePersistenceInstanceDescriptorBuildItem((String)namedInstance.getKey(), entityViewClassesPerBlazePersistenceInstance.getOrDefault(namedInstance.getKey(), Collections.emptySet()), entityViewListenerClassesPerBlazePersistenceInstance.getOrDefault(namedInstance.getKey(), Collections.emptySet())));
        }
    }

    @BuildStep
    void reflection(EntityViewsBuildItem entityViewsBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectionProducer) {
        reflectionProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{ValuesEntity.class}));
        reflectionProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new Class[]{ConcurrentHashMapExpressionCache.class}));
        reflectionProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{"com.blazebit.persistence.integration.hibernate.CustomOneToManyPersister"}));
        reflectionProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{"com.blazebit.persistence.integration.hibernate.CustomBasicCollectionPersister"}));
        reflectionProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.hibernate.dialect.function.SQLFunctionRegistry"}).fields(true).finalFieldsWritable(true).build());
        reflectionProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.hibernate.dialect.Dialect"}).fields(true).finalFieldsWritable(true).build());
        reflectionProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.hibernate.hql.internal.ast.exec.MultiTableUpdateExecutor", "org.hibernate.hql.internal.ast.exec.BasicExecutor", "org.hibernate.hql.internal.ast.exec.DeleteExecutor", "org.hibernate.hql.internal.ast.exec.MultiTableDeleteExecutor", "org.hibernate.hql.internal.ast.exec.IdSubselectUpdateExecutor", "org.hibernate.hql.internal.ast.exec.SimpleUpdateExecutor", "org.hibernate.hql.internal.ast.exec.InsertExecutor"}).fields(true).finalFieldsWritable(true).build());
        reflectionProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.hibernate.hql.internal.classic.QueryTranslatorImpl", "org.hibernate.hql.internal.ast.QueryTranslatorImpl"}).fields(true).build());
        for (String entityViewClassName : entityViewsBuildItem.getEntityViewClassNames()) {
            reflectionProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new String[]{entityViewClassName}));
            String baseName = entityViewClassName.replace("$", "");
            reflectionProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{baseName + "Impl"}).constructors(true).fields(true).methods(true).finalFieldsWritable(true).build());
            reflectionProducer.produce((BuildItem)new ReflectiveClassBuildItem(false, false, true, new String[]{baseName + "_"}));
            for (String generatedStaticModelClass : Arrays.asList(baseName + "Relation", baseName + "MultiRelation")) {
                reflectionProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{generatedStaticModelClass}));
            }
            try {
                Class<?> builderClass = Thread.currentThread().getContextClassLoader().loadClass(baseName + "Builder");
                reflectionProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{builderClass.getName()}));
                for (Class<?> builderSubClass : builderClass.getDeclaredClasses()) {
                    reflectionProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{builderSubClass.getName()}));
                }
            }
            catch (ClassNotFoundException builderClass) {
            }
        }
        EntityViewConfiguration evc = EntityViews.createDefaultConfiguration();
        for (String entityViewClassName : entityViewsBuildItem.getEntityViewClassNames()) {
            try {
                evc.addEntityView(Thread.currentThread().getContextClassLoader().loadClass(entityViewClassName));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        for (EntityViewMapping entityViewMapping : evc.getEntityViewMappings()) {
            if (entityViewMapping.getIdAttribute() == null) continue;
            reflectionProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{entityViewMapping.getIdAttribute().getDeclaredType()}).constructors(true).methods(true).build());
        }
    }

    private List<String> getGeneratedEntityViewModelClassNames(String entityViewClassName) {
        return Arrays.asList(entityViewClassName.replace("$", "") + "_", entityViewClassName.replace("$", "") + "Relation", entityViewClassName.replace("$", "") + "MultiRelation", entityViewClassName.replace("$", "") + "Builder", entityViewClassName.replace("$", "") + "Builder$Init");
    }

    @BuildStep
    ServiceProviderBuildItem criteriaBuilderConfigurationProvider() {
        return new ServiceProviderBuildItem("com.blazebit.persistence.spi.CriteriaBuilderConfigurationProvider", new String[]{"com.blazebit.persistence.impl.CriteriaBuilderConfigurationProviderImpl"});
    }

    @BuildStep
    ServiceProviderBuildItem entityViewConfigurationProvider() {
        return new ServiceProviderBuildItem("com.blazebit.persistence.view.spi.EntityViewConfigurationProvider", new String[]{"com.blazebit.persistence.view.impl.EntityViewConfigurationProviderImpl"});
    }

    @BuildStep
    ServiceProviderBuildItem blazeCriteriaBuilderFactory() {
        return new ServiceProviderBuildItem("com.blazebit.persistence.criteria.spi.BlazeCriteriaBuilderFactory", new String[]{"com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderFactoryImpl"});
    }

    @BuildStep
    ServiceProviderBuildItem extendedQuerySupport() {
        return new ServiceProviderBuildItem("com.blazebit.persistence.spi.ExtendedQuerySupport", new String[]{"com.blazebit.persistence.integration.hibernate.base.HibernateExtendedQuerySupport"});
    }

    @BuildStep
    ServiceProviderBuildItem hibernateAccess() {
        return new ServiceProviderBuildItem("com.blazebit.persistence.integration.hibernate.base.HibernateAccess", new String[]{"com.blazebit.persistence.integration.hibernate.Hibernate62Access"});
    }

    @BuildStep
    ServiceProviderBuildItem entityManagerFactoryIntegrator() {
        return new ServiceProviderBuildItem("com.blazebit.persistence.spi.EntityManagerFactoryIntegrator", new String[]{"com.blazebit.persistence.integration.hibernate.Hibernate62EntityManagerFactoryIntegrator"});
    }

    @BuildStep
    ServiceProviderBuildItem transactionAccessFactory() {
        return new ServiceProviderBuildItem("com.blazebit.persistence.view.spi.TransactionAccessFactory", new String[]{"com.blazebit.persistence.integration.hibernate.Hibernate6TransactionAccessFactory"});
    }

    @BuildStep
    ServiceProviderBuildItem hibernateAdditionalMappingContributor() {
        return new ServiceProviderBuildItem("org.hibernate.boot.spi.AdditionalMappingContributor", new String[]{"com.blazebit.persistence.integration.hibernate.Hibernate62AdditionalMappingContributor"});
    }

    @BuildStep
    ServiceProviderBuildItem hibernateTypeContributor() {
        return new ServiceProviderBuildItem("org.hibernate.metamodel.spi.TypeContributor", new String[]{"com.blazebit.persistence.integration.hibernate.Hibernate62Integrator"});
    }

    private static Map<String, Set<String>> buildClassesToBlazePersistenceInstanceMapping(Map<String, Set<String>> blazePersistenceInstanceToPackageMapping, Set<String> classes, IndexView index) {
        HashMap<String, Set<String>> entityViewClassesPerBlazePersistenceInstance = new HashMap<String, Set<String>>();
        TreeSet<String> entityViewClassesWithBlazePersistenceInstanceAnnotations = new TreeSet<String>();
        for (String entityViewClassName : classes) {
            ClassInfo entityViewClassInfo = index.getClassByName(DotName.createSimple((String)entityViewClassName));
            Set<String> relatedEntityViewClassNames = Collections.emptySet();
            if (entityViewClassInfo != null && (entityViewClassInfo.classAnnotation(BLAZE_PERSISTENCE_INSTANCE) != null || entityViewClassInfo.classAnnotation(BLAZE_PERSISTENCE_INSTANCE_REPEATABLE_CONTAINER) != null)) {
                entityViewClassesWithBlazePersistenceInstanceAnnotations.add(entityViewClassInfo.name().toString());
            }
            for (Map.Entry<String, Set<String>> packageRuleEntry : blazePersistenceInstanceToPackageMapping.entrySet()) {
                if (!entityViewClassName.startsWith(packageRuleEntry.getKey())) continue;
                for (String blazePersistenceInstanceName : packageRuleEntry.getValue()) {
                    entityViewClassesPerBlazePersistenceInstance.computeIfAbsent(blazePersistenceInstanceName, key -> new HashSet()).add(entityViewClassName);
                    for (String relatedEntityViewClassName : relatedEntityViewClassNames) {
                        ((Set)entityViewClassesPerBlazePersistenceInstance.get(blazePersistenceInstanceName)).add(relatedEntityViewClassName);
                    }
                }
            }
        }
        if (!entityViewClassesWithBlazePersistenceInstanceAnnotations.isEmpty()) {
            throw new IllegalStateException(String.format("@BlazePersistenceInstance annotations are not supported at the class level on entity view classes:\n\t- %s\nUse the `.packages` configuration property or package-level annotations instead.", String.join((CharSequence)"\n\t- ", entityViewClassesWithBlazePersistenceInstanceAnnotations)));
        }
        Set affectedEntityViewClasses = entityViewClassesPerBlazePersistenceInstance.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Set unaffectedEntityViewClasses = classes.stream().filter(c -> !affectedEntityViewClasses.contains(c)).collect(Collectors.toCollection(TreeSet::new));
        if (!unaffectedEntityViewClasses.isEmpty()) {
            LOG.warnf("Could not find a suitable Blaze-Persistence instance for entity view classes:\n\t- %s", (Object)String.join((CharSequence)"\n\t- ", unaffectedEntityViewClasses));
        }
        return entityViewClassesPerBlazePersistenceInstance;
    }

    private static Map<String, Set<String>> mapBlazePersistenceInstancesToPackages(BlazePersistenceConfiguration blazePersistenceConfig, boolean enableDefaultBlazePersistenceInstance, boolean hasPackagesInQuarkusConfig, Collection<AnnotationInstance> packageLevelBlazePersistenceInstanceAnnotations) {
        HashMap<String, Set<String>> packageRules = new HashMap<String, Set<String>>();
        if (hasPackagesInQuarkusConfig) {
            if (!packageLevelBlazePersistenceInstanceAnnotations.isEmpty()) {
                LOG.warn((Object)"Mixing Quarkus configuration and @BlazePersistenceInstance annotations to define the Blaze-Persistence instances is not supported. Ignoring the annotations.");
            }
            for (Map.Entry candidateBlazePersistenceInstanceEntry : blazePersistenceConfig.blazePersistenceInstances().entrySet()) {
                String candidateBlazePersistenceInstanceName = (String)candidateBlazePersistenceInstanceEntry.getKey();
                if (BlazePersistenceInstanceUtil.isDefaultBlazePersistenceInstance((String)candidateBlazePersistenceInstanceName) && !enableDefaultBlazePersistenceInstance) continue;
                Set candidateBlazePersistenceInstancePackages = (Set)((BlazePersistenceInstanceConfiguration)candidateBlazePersistenceInstanceEntry.getValue()).packages().orElseThrow(() -> new ConfigurationException(String.format("Packages must be configured for Blaze-Persistence instance '%s'.", candidateBlazePersistenceInstanceName)));
                for (String packageName : candidateBlazePersistenceInstancePackages) {
                    packageRules.computeIfAbsent(BlazePersistenceProcessor.normalizePackage(packageName), p -> new HashSet()).add(candidateBlazePersistenceInstanceName);
                }
            }
        } else if (!packageLevelBlazePersistenceInstanceAnnotations.isEmpty()) {
            for (AnnotationInstance packageLevelBlazePersistenceInstanceAnnotation : packageLevelBlazePersistenceInstanceAnnotations) {
                String className = packageLevelBlazePersistenceInstanceAnnotation.target().asClass().name().toString();
                String packageName = className == null || className.isEmpty() || className.indexOf(46) == -1 ? "" : BlazePersistenceProcessor.normalizePackage(className.substring(0, className.lastIndexOf(46)));
                String blazePersistenceInstanceName = packageLevelBlazePersistenceInstanceAnnotation.value().asString();
                if (blazePersistenceInstanceName == null || blazePersistenceInstanceName.isEmpty()) continue;
                packageRules.computeIfAbsent(packageName, p -> new HashSet()).add(blazePersistenceInstanceName);
            }
        } else {
            throw new ConfigurationException("Multiple Blaze-Persistence instances are defined but the entity views are not mapped to them. You should either use the .packages Quarkus configuration property or package-level @BlazePersistenceInstance annotations.");
        }
        return packageRules;
    }

    private static boolean hasPackagesInQuarkusConfig(BlazePersistenceConfiguration blazePersistenceConfig) {
        for (BlazePersistenceInstanceConfiguration blazePersistenceInstanceConfig : blazePersistenceConfig.blazePersistenceInstances().values()) {
            if (!blazePersistenceInstanceConfig.packages().isPresent()) continue;
            return true;
        }
        return false;
    }

    private static Collection<AnnotationInstance> getPackageLevelBlazePersistenceInstanceAnnotations(IndexView index) {
        Collection blazePersistenceInstanceAnnotations = index.getAnnotationsWithRepeatable(BLAZE_PERSISTENCE_INSTANCE, index);
        ArrayList<AnnotationInstance> packageLevelBlazePersistenceInstanceAnnotations = new ArrayList<AnnotationInstance>();
        for (AnnotationInstance blazePersistenceInstanceAnnotation : blazePersistenceInstanceAnnotations) {
            if (blazePersistenceInstanceAnnotation.target().kind() != AnnotationTarget.Kind.CLASS || !"package-info".equals(blazePersistenceInstanceAnnotation.target().asClass().simpleName())) continue;
            packageLevelBlazePersistenceInstanceAnnotations.add(blazePersistenceInstanceAnnotation);
        }
        return packageLevelBlazePersistenceInstanceAnnotations;
    }

    private static String normalizePackage(String pakkage) {
        if (pakkage.endsWith(".")) {
            return pakkage;
        }
        return pakkage + ".";
    }
}

