/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.quarkus.deployment;

import com.blazebit.persistence.integration.quarkus.deployment.EntityViewListenersBuildItem;
import com.blazebit.persistence.integration.quarkus.deployment.EntityViewsBuildItem;
import com.blazebit.persistence.view.EntityView;
import com.blazebit.persistence.view.EntityViewListener;
import com.blazebit.persistence.view.EntityViewListeners;
import java.util.Collection;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class EntityViewJandexScavenger {
    private static final DotName ENTITY_VIEW = DotName.createSimple((String)EntityView.class.getName());
    private static final DotName ENTITY_VIEW_LISTENER = DotName.createSimple((String)EntityViewListener.class.getName());
    private static final DotName ENTITY_VIEW_LISTENERS = DotName.createSimple((String)EntityViewListeners.class.getName());
    private final IndexView indexView;

    public EntityViewJandexScavenger(IndexView indexView) {
        this.indexView = indexView;
    }

    public EntityViewsBuildItem discoverAndRegisterEntityViews() {
        EntityViewsBuildItem entityViewsBuildItem = new EntityViewsBuildItem();
        Collection entityViewAnnotations = this.indexView.getAnnotations(ENTITY_VIEW);
        if (entityViewAnnotations != null) {
            for (AnnotationInstance annotation : entityViewAnnotations) {
                ClassInfo klass = annotation.target().asClass();
                entityViewsBuildItem.addEntityViewClass(klass.name().toString());
            }
        }
        return entityViewsBuildItem;
    }

    public EntityViewListenersBuildItem discoverAndRegisterEntityViewListeners() {
        Collection entityViewListenersAnnotations;
        EntityViewListenersBuildItem entityViewListenersBuildItem = new EntityViewListenersBuildItem();
        Collection entityViewListenerAnnotations = this.indexView.getAnnotations(ENTITY_VIEW_LISTENER);
        if (entityViewListenerAnnotations != null) {
            for (AnnotationInstance annotation : entityViewListenerAnnotations) {
                ClassInfo klass = annotation.target().asClass();
                entityViewListenersBuildItem.addEntityViewListenerClass(klass.name().toString());
            }
        }
        if ((entityViewListenersAnnotations = this.indexView.getAnnotations(ENTITY_VIEW_LISTENERS)) != null) {
            for (AnnotationInstance annotation : entityViewListenersAnnotations) {
                ClassInfo klass = annotation.target().asClass();
                entityViewListenersBuildItem.addEntityViewListenerClass(klass.name().toString());
            }
        }
        return entityViewListenersBuildItem;
    }
}

