/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.quarkus.runtime;

import com.blazebit.persistence.spi.CriteriaBuilderConfiguration;
import com.blazebit.persistence.view.spi.EntityViewConfiguration;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.util.Optional;
import java.util.Set;

@ConfigGroup
public interface BlazePersistenceInstanceConfiguration {
    public Optional<String> persistenceUnit();

    public Optional<Set<String>> packages();

    @WithDefault(value="false")
    public boolean templateEagerLoading();

    @WithDefault(value="false")
    public boolean managedTypeValidationDisabled();

    @WithDefault(value="1")
    public int defaultBatchSize();

    @WithDefault(value="values")
    public String expectBatchMode();

    @WithName(value="updater.eager-loading")
    @WithDefault(value="false")
    public boolean updaterEagerLoading();

    @WithName(value="updater.disallow-owned-updatable-subview")
    @WithDefault(value="true")
    public boolean updaterDisallowOwnedUpdatableSubview();

    @WithName(value="updater.strict-cascading-check")
    @WithDefault(value="true")
    public boolean updaterStrictCascadingCheck();

    @WithName(value="updater.error-on-invalid-plural-setter")
    @WithDefault(value="false")
    public boolean updaterErrorOnInvalidPluralSetter();

    @WithDefault(value="true")
    public boolean createEmptyFlatViews();

    @WithDefault(value="com.blazebit.persistence.parser.expression.ConcurrentHashMapExpressionCache")
    public String expressionCacheClass();

    @WithDefault(value="true")
    public boolean inlineCtes();

    @WithDefault(value="true")
    public boolean queryPlanCacheEnabled();

    default public void apply(CriteriaBuilderConfiguration criteriaBuilderConfiguration) {
        criteriaBuilderConfiguration.setProperty("com.blazebit.persistence.expression.cache_class", this.expressionCacheClass());
        criteriaBuilderConfiguration.setProperty("com.blazebit.persistence.inline_ctes", Boolean.toString(this.inlineCtes()));
        criteriaBuilderConfiguration.setProperty("com.blazebit.persistence.query_plan_cache_enabled", Boolean.toString(this.queryPlanCacheEnabled()));
    }

    default public void apply(EntityViewConfiguration entityViewConfiguration) {
        entityViewConfiguration.setProperty("com.blazebit.persistence.view.eager_loading", Boolean.toString(this.templateEagerLoading()));
        entityViewConfiguration.setProperty("com.blazebit.persistence.view.managed_type_validation_disabled", Boolean.toString(this.managedTypeValidationDisabled()));
        entityViewConfiguration.setProperty("com.blazebit.persistence.view.batch_size", Integer.toString(this.defaultBatchSize()));
        entityViewConfiguration.setProperty("com.blazebit.persistence.view.batch_mode", this.expectBatchMode());
        entityViewConfiguration.setProperty("com.blazebit.persistence.view.updater.eager_loading", Boolean.toString(this.updaterEagerLoading()));
        entityViewConfiguration.setProperty("com.blazebit.persistence.view.updater.disallow_owned_updatable_subview", Boolean.toString(this.updaterDisallowOwnedUpdatableSubview()));
        entityViewConfiguration.setProperty("com.blazebit.persistence.view.updater.strict_cascading_check", Boolean.toString(this.updaterStrictCascadingCheck()));
        entityViewConfiguration.setProperty("com.blazebit.persistence.view.updater.error_on_invalid_plural_setter", Boolean.toString(this.updaterErrorOnInvalidPluralSetter()));
        entityViewConfiguration.setProperty("com.blazebit.persistence.view.create_empty_flat_views", Boolean.toString(this.createEmptyFlatViews()));
    }

    default public boolean isAnyPropertySet() {
        return !this.createEmptyFlatViews() || this.defaultBatchSize() != 1 || !"values".equals(this.expectBatchMode()) || !"com.blazebit.persistence.parser.expression.ConcurrentHashMapExpressionCache".equals(this.expressionCacheClass()) || !this.queryPlanCacheEnabled() || !this.inlineCtes() || this.persistenceUnit().isPresent() || this.packages().isPresent() || this.templateEagerLoading() || this.managedTypeValidationDisabled() || !this.updaterDisallowOwnedUpdatableSubview() || this.updaterEagerLoading() || this.updaterErrorOnInvalidPluralSetter() || !this.updaterStrictCascadingCheck();
    }
}

