/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.quarkus.runtime;

import com.blazebit.persistence.Criteria;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.integration.quarkus.runtime.BlazePersistenceConfiguration;
import com.blazebit.persistence.integration.quarkus.runtime.BlazePersistenceInstance;
import com.blazebit.persistence.integration.quarkus.runtime.BlazePersistenceInstanceUtil;
import com.blazebit.persistence.spi.CriteriaBuilderConfiguration;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.EntityViews;
import com.blazebit.persistence.view.spi.EntityViewConfiguration;
import io.quarkus.arc.Arc;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Default;
import jakarta.persistence.EntityManagerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.Supplier;

@Recorder
public class EntityViewRecorder {
    private static final Method GET_ENTITY_MANAGER_FACTORY;

    public Supplier<CriteriaBuilderFactory> criteriaBuilderFactorySupplier(BlazePersistenceConfiguration blazePersistenceConfig, String blazePersistenceInstanceName, String persistenceUnitName) {
        return () -> {
            Object[] objectArray;
            CriteriaBuilderConfiguration criteriaBuilderConfiguration = Criteria.getDefault();
            blazePersistenceConfig.blazePersistenceInstances().get(blazePersistenceInstanceName).apply(criteriaBuilderConfiguration);
            Annotation[] cbfQualifiers = BlazePersistenceInstanceUtil.isDefaultBlazePersistenceInstance(blazePersistenceInstanceName) ? new Annotation[]{new Default.Literal()} : new Annotation[]{new BlazePersistenceInstance.BlazePersistenceInstanceLiteral(blazePersistenceInstanceName)};
            Arc.container().beanManager().getEvent().select(CriteriaBuilderConfiguration.class, cbfQualifiers).fire((Object)criteriaBuilderConfiguration);
            JPAConfig jpaConfig = (JPAConfig)Arc.container().instance(JPAConfig.class, new Annotation[0]).get();
            if (GET_ENTITY_MANAGER_FACTORY.getParameterCount() == 1) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = persistenceUnitName;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = persistenceUnitName;
                objectArray = objectArray3;
                objectArray3[1] = false;
            }
            Object[] args = objectArray;
            try {
                EntityManagerFactory emf = (EntityManagerFactory)GET_ENTITY_MANAGER_FACTORY.invoke((Object)jpaConfig, args);
                return criteriaBuilderConfiguration.createCriteriaBuilderFactory(emf);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Unable to find method to access EntityManagerFactory. Please report this issue.", e);
            }
        };
    }

    public Supplier<EntityViewManager> entityViewManagerSupplier(BlazePersistenceConfiguration blazePersistenceConfig, String blazePersistenceInstanceName, Set<String> entityViewClasses, Set<String> entityViewListenerClasses) {
        return () -> {
            EntityViewConfiguration entityViewConfiguration = EntityViews.createDefaultConfiguration();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (String entityViewClass : entityViewClasses) {
                try {
                    entityViewConfiguration.addEntityView(classLoader.loadClass(entityViewClass));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            for (String entityViewListenerClass : entityViewListenerClasses) {
                try {
                    entityViewConfiguration.addEntityViewListener(classLoader.loadClass(entityViewListenerClass));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            blazePersistenceConfig.blazePersistenceInstances().get(blazePersistenceInstanceName).apply(entityViewConfiguration);
            entityViewConfiguration.setProperty("com.blazebit.persistence.view.proxy.unsafe_allowed", Boolean.FALSE.toString());
            Annotation[] cbfQualifiers = BlazePersistenceInstanceUtil.isDefaultBlazePersistenceInstance(blazePersistenceInstanceName) ? new Annotation[]{new Default.Literal()} : new Annotation[]{new BlazePersistenceInstance.BlazePersistenceInstanceLiteral(blazePersistenceInstanceName)};
            Arc.container().beanManager().getEvent().select(EntityViewConfiguration.class, cbfQualifiers).fire((Object)entityViewConfiguration);
            CriteriaBuilderFactory cbf = (CriteriaBuilderFactory)Arc.container().instance(CriteriaBuilderFactory.class, cbfQualifiers).get();
            return entityViewConfiguration.createEntityViewManager(cbf);
        };
    }

    static {
        Method method;
        try {
            method = JPAConfig.class.getMethod("getEntityManagerFactory", String.class);
        }
        catch (NoSuchMethodException e) {
            try {
                method = JPAConfig.class.getMethod("getEntityManagerFactory", String.class, Boolean.TYPE);
            }
            catch (NoSuchMethodException e2) {
                throw new RuntimeException("Unable to find method to access EntityManagerFactory. Please report this issue.", e2);
            }
        }
        GET_ENTITY_MANAGER_FACTORY = method;
    }
}

