/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.quarkus.deployment;

import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.integration.quarkus.deployment.BlazePersistenceInstanceDescriptorBuildItem;
import com.blazebit.persistence.integration.quarkus.runtime.BlazePersistenceInstance;
import com.blazebit.persistence.integration.quarkus.runtime.BlazePersistenceInstanceConfiguration;
import com.blazebit.persistence.integration.quarkus.runtime.BlazePersistenceInstanceUtil;
import com.blazebit.persistence.integration.quarkus.runtime.EntityViewRecorder;
import com.blazebit.persistence.view.EntityViewManager;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import java.util.List;
import java.util.function.Supplier;
import javax.enterprise.inject.Default;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;

class BlazePersistenceCdiProcessor {
    private static final DotName BLAZE_PERSISTENCE_INSTANCE_QUALIFIER = DotName.createSimple((String)BlazePersistenceInstance.class.getName());
    private static final DotName CRITERIA_BUILDER_FACTORY = DotName.createSimple((String)CriteriaBuilderFactory.class.getName());
    private static final DotName ENTITY_VIEW_MANAGER = DotName.createSimple((String)EntityViewManager.class.getName());

    BlazePersistenceCdiProcessor() {
    }

    @BuildStep
    AnnotationsTransformerBuildItem convertJpaResourceAnnotationsToQualifier(final List<BlazePersistenceInstanceDescriptorBuildItem> blazePersistenceDescriptors) {
        AnnotationsTransformer transformer = new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.FIELD;
            }

            public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
                FieldInfo field = transformationContext.getTarget().asField();
                if (!ENTITY_VIEW_MANAGER.equals((Object)field.type().name()) && !CRITERIA_BUILDER_FACTORY.equals((Object)field.type().name())) {
                    return;
                }
                if (!field.hasAnnotation(BLAZE_PERSISTENCE_INSTANCE_QUALIFIER)) {
                    return;
                }
                DotName blazePersistenceInstanceAnnotation = BLAZE_PERSISTENCE_INSTANCE_QUALIFIER;
                AnnotationValue blazePersistenceInstanceAnnotationValue = field.annotation(blazePersistenceInstanceAnnotation).value();
                Transformation transformation = (Transformation)transformationContext.transform().add(DotNames.INJECT, new AnnotationValue[0]);
                if (blazePersistenceInstanceAnnotationValue == null || blazePersistenceInstanceAnnotationValue.asString().isEmpty()) {
                    transformation.add(DotNames.DEFAULT, new AnnotationValue[0]);
                } else if (blazePersistenceDescriptors.size() == 1 && ((BlazePersistenceInstanceDescriptorBuildItem)((Object)blazePersistenceDescriptors.get(0))).getBlazePersistenceInstanceName().equals(blazePersistenceInstanceAnnotationValue.asString())) {
                    transformation.add(DotNames.DEFAULT, new AnnotationValue[0]);
                }
                transformation.done();
            }
        };
        return new AnnotationsTransformerBuildItem(transformer);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void generateBeans(EntityViewRecorder recorder, List<BlazePersistenceInstanceDescriptorBuildItem> blazePersistenceDescriptors, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        if (blazePersistenceDescriptors.isEmpty()) {
            return;
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(BlazePersistenceInstance.class).build());
        if (blazePersistenceDescriptors.size() == 1) {
            BlazePersistenceInstanceDescriptorBuildItem blazePersistenceDescriptor = blazePersistenceDescriptors.get(0);
            String blazePersistenceInstanceName = blazePersistenceDescriptor.getBlazePersistenceInstanceName();
            BlazePersistenceInstanceConfiguration blazePersistenceConfig = blazePersistenceDescriptor.getBlazePersistenceConfig();
            String persistenceUnitName = blazePersistenceConfig.persistenceUnit.orElse("<default>");
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)BlazePersistenceCdiProcessor.createSyntheticBean(blazePersistenceInstanceName, true, CriteriaBuilderFactory.class, recorder.criteriaBuilderFactorySupplier(blazePersistenceConfig, blazePersistenceInstanceName, persistenceUnitName), true));
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)BlazePersistenceCdiProcessor.createSyntheticBean(blazePersistenceInstanceName, true, EntityViewManager.class, recorder.entityViewManagerSupplier(blazePersistenceConfig, blazePersistenceInstanceName, blazePersistenceDescriptor.getEntityViewClasses(), blazePersistenceDescriptor.getEntityViewListenerClasses()), false));
            return;
        }
        for (BlazePersistenceInstanceDescriptorBuildItem blazePersistenceDescriptor : blazePersistenceDescriptors) {
            String blazePersistenceInstanceName = blazePersistenceDescriptor.getBlazePersistenceInstanceName();
            BlazePersistenceInstanceConfiguration blazePersistenceConfig = blazePersistenceDescriptor.getBlazePersistenceConfig();
            String persistenceUnitName = blazePersistenceConfig.persistenceUnit.orElse("<default>");
            boolean defaultBlazePersistenceInstance = BlazePersistenceInstanceUtil.isDefaultBlazePersistenceInstance((String)blazePersistenceInstanceName);
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)BlazePersistenceCdiProcessor.createSyntheticBean(blazePersistenceInstanceName, defaultBlazePersistenceInstance, CriteriaBuilderFactory.class, recorder.criteriaBuilderFactorySupplier(blazePersistenceConfig, blazePersistenceInstanceName, persistenceUnitName), true));
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)BlazePersistenceCdiProcessor.createSyntheticBean(blazePersistenceInstanceName, defaultBlazePersistenceInstance, EntityViewManager.class, recorder.entityViewManagerSupplier(blazePersistenceConfig, blazePersistenceInstanceName, blazePersistenceDescriptor.getEntityViewClasses(), blazePersistenceDescriptor.getEntityViewListenerClasses()), false));
        }
    }

    private static <T> SyntheticBeanBuildItem createSyntheticBean(String blazePersistenceInstanceName, boolean isDefaultBlazePersistenceInstance, Class<T> type, Supplier<T> supplier, boolean defaultBean) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(type).scope(Singleton.class)).setRuntimeInit().unremovable()).supplier(supplier);
        if (defaultBean) {
            configurator.defaultBean();
        }
        if (isDefaultBlazePersistenceInstance) {
            configurator.addQualifier(Default.class);
        } else {
            configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)blazePersistenceInstanceName).done();
            configurator.addQualifier().annotation(BlazePersistenceInstance.class).addValue("value", (Object)blazePersistenceInstanceName).done();
        }
        return configurator.done();
    }
}

