/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.querydsl;

import com.blazebit.persistence.querydsl.WindowDefinition;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.SimpleTemplate;
import java.util.Objects;
import javax.annotation.Nullable;

public class WindowFunction<A>
extends WindowDefinition<WindowFunction<A>, A> {
    private static final long serialVersionUID = 5108488516938771478L;
    private final Expression<A> target;
    @Nullable
    private volatile transient SimpleExpression<A> value;

    public WindowFunction(Expression<A> expr) {
        super(expr.getType());
        this.target = expr;
    }

    public WindowFunction(Expression<A> expr, String baseWindowName) {
        super(expr.getType(), baseWindowName);
        this.target = expr;
    }

    @Override
    public SimpleExpression<A> getValue() {
        SimpleTemplate value = this.value;
        if (value == null) {
            this.value = value = Expressions.template((Class)this.target.getType(), (String)"{0} over ({1})", (Object[])new Object[]{this.target, super.getValue()});
        }
        return value;
    }

    public SimpleExpression<A> as(Expression<A> alias) {
        return Expressions.operation((Class)this.getType(), (Operator)Ops.ALIAS, (Expression[])new Expression[]{this, alias});
    }

    public SimpleExpression<A> as(String alias) {
        return Expressions.operation((Class)this.getType(), (Operator)Ops.ALIAS, (Expression[])new Expression[]{this, ExpressionUtils.path((Class)this.getType(), (String)alias)});
    }

    public BooleanExpression eq(Expression<A> expr) {
        return this.getValue().eq(expr);
    }

    public BooleanExpression eq(A arg) {
        return this.getValue().eq(arg);
    }

    public BooleanExpression ne(Expression<A> expr) {
        return this.getValue().ne(expr);
    }

    public BooleanExpression ne(A arg) {
        return this.getValue().ne(arg);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WindowFunction that = (WindowFunction)((Object)o);
        return Objects.equals(this.target, that.target) && super.equals(o);
    }
}

