/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.impl.query;

import com.blazebit.persistence.spring.data.base.query.JpaParameters;
import com.blazebit.persistence.spring.data.base.query.ParameterMetadataProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.ParameterExpression;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.expression.Expression;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class ParameterMetadataProviderImpl
implements ParameterMetadataProvider {
    private final CriteriaBuilder builder;
    private final Iterator<? extends JpaParameters.JpaParameter> parameters;
    private final List<ParameterMetadataProvider.ParameterMetadata<?>> expressions;
    private final Iterator<Object> bindableParameterValues;
    private final PersistenceProvider persistenceProvider;

    public ParameterMetadataProviderImpl(CriteriaBuilder builder, ParametersParameterAccessor accessor, PersistenceProvider provider) {
        this(builder, (Iterator<Object>)accessor.iterator(), (JpaParameters)accessor.getParameters(), provider);
    }

    public ParameterMetadataProviderImpl(CriteriaBuilder builder, JpaParameters parameters, PersistenceProvider provider) {
        this(builder, null, parameters, provider);
    }

    private ParameterMetadataProviderImpl(CriteriaBuilder builder, Iterator<Object> bindableParameterValues, JpaParameters parameters, PersistenceProvider provider) {
        Assert.notNull((Object)builder, (String)"CriteriaBuilder must not be null!");
        Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
        Assert.notNull((Object)provider, (String)"PesistenceProvider must not be null!");
        this.builder = builder;
        this.parameters = ((JpaParameters)parameters.getBindableParameters()).iterator();
        this.expressions = new ArrayList();
        this.bindableParameterValues = bindableParameterValues;
        this.persistenceProvider = provider;
    }

    public List<ParameterMetadataProvider.ParameterMetadata<?>> getExpressions() {
        return Collections.unmodifiableList(this.expressions);
    }

    public <T> ParameterMetadataProvider.ParameterMetadata<T> next(Part part) {
        Assert.isTrue((boolean)this.parameters.hasNext(), (String)String.format("No parameter available for part %s.", part));
        JpaParameters.JpaParameter parameter = this.parameters.next();
        return this.next(part, parameter.getType(), parameter);
    }

    public <T> ParameterMetadataProvider.ParameterMetadata<? extends T> next(Part part, Class<T> type) {
        JpaParameters.JpaParameter parameter = this.parameters.next();
        Class typeToUse = ClassUtils.isAssignable(type, (Class)parameter.getType()) ? parameter.getType() : type;
        return this.next(part, typeToUse, parameter);
    }

    private <T> ParameterMetadataProvider.ParameterMetadata<T> next(Part part, Class<T> type, JpaParameters.JpaParameter parameter) {
        Assert.notNull(type, (String)"Type must not be null!");
        Class reifiedType = Expression.class.equals(type) ? Object.class : type;
        ParameterExpression expression = parameter.isExplicitlyNamed() ? this.builder.parameter(reifiedType, parameter.getParameterName()) : this.builder.parameter(reifiedType);
        ParameterMetadataImpl value = new ParameterMetadataImpl(expression, part.getType(), this.bindableParameterValues == null ? ParameterMetadataProvider.ParameterMetadata.PLACEHOLDER : this.bindableParameterValues.next(), this.persistenceProvider);
        this.expressions.add(value);
        return value;
    }

    public static class ParameterMetadataImpl<T>
    implements ParameterMetadataProvider.ParameterMetadata<T> {
        private final Part.Type type;
        private final ParameterExpression<T> expression;
        private final PersistenceProvider persistenceProvider;

        public ParameterMetadataImpl(ParameterExpression<T> expression, Part.Type type, Object value, PersistenceProvider provider) {
            this.expression = expression;
            this.persistenceProvider = provider;
            this.type = value == null && Part.Type.SIMPLE_PROPERTY.equals((Object)type) ? Part.Type.IS_NULL : type;
        }

        public ParameterExpression<T> getExpression() {
            return this.expression;
        }

        public boolean isIsNullParameter() {
            return Part.Type.IS_NULL.equals((Object)this.type);
        }

        public Object prepare(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            Class expressionType = this.expression.getJavaType();
            if (String.class.equals((Object)expressionType)) {
                switch (this.type) {
                    case STARTING_WITH: {
                        return String.format("%s%%", value.toString());
                    }
                    case ENDING_WITH: {
                        return String.format("%%%s", value.toString());
                    }
                    case CONTAINING: 
                    case NOT_CONTAINING: {
                        return String.format("%%%s%%", value.toString());
                    }
                }
                return value;
            }
            return Collection.class.isAssignableFrom(expressionType) ? this.persistenceProvider.potentiallyConvertEmptyCollection(ParameterMetadataImpl.toCollection(value)) : value;
        }

        private static Collection<?> toCollection(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Collection) {
                return (Collection)value;
            }
            if (ObjectUtils.isArray((Object)value)) {
                return Arrays.asList(ObjectUtils.toObjectArray((Object)value));
            }
            return Collections.singleton(value);
        }
    }
}

