/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.impl.repository;

import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spring.data.base.query.EntityViewAwareJpaQueryMethod;
import com.blazebit.persistence.spring.data.base.query.EntityViewAwareRepositoryMetadata;
import com.blazebit.persistence.spring.data.base.repository.AbstractEntityViewAwareRepository;
import com.blazebit.persistence.spring.data.base.repository.EntityViewAwareCrudMethodMetadata;
import com.blazebit.persistence.spring.data.base.repository.EntityViewAwareCrudMethodMetadataPostProcessor;
import com.blazebit.persistence.spring.data.impl.query.EntityViewAwareRepositoryInformation;
import com.blazebit.persistence.spring.data.impl.query.EntityViewAwareRepositoryMetadataImpl;
import com.blazebit.persistence.spring.data.impl.query.PartTreeBlazePersistenceQuery;
import com.blazebit.persistence.spring.data.impl.repository.EntityViewAwareRepositoryImpl;
import com.blazebit.persistence.spring.data.repository.EntityViewReplacingMethodInterceptor;
import com.blazebit.persistence.view.EntityViewManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

public class BlazePersistenceRepositoryFactory
extends JpaRepositoryFactory {
    private final EntityManager entityManager;
    private final CriteriaBuilderFactory cbf;
    private final EntityViewManager evm;
    private final QueryExtractor extractor;
    private final EntityViewReplacingMethodInterceptor entityViewReplacingMethodInterceptor;
    private List<RepositoryProxyPostProcessor> postProcessors;
    private EntityViewAwareCrudMethodMetadataPostProcessor crudMethodMetadataPostProcessor;

    public BlazePersistenceRepositoryFactory(EntityManager entityManager, CriteriaBuilderFactory cbf, EntityViewManager evm) {
        super(entityManager);
        this.entityManager = entityManager;
        this.extractor = PersistenceProvider.fromEntityManager((EntityManager)entityManager);
        this.cbf = cbf;
        this.evm = evm;
        this.crudMethodMetadataPostProcessor = new EntityViewAwareCrudMethodMetadataPostProcessor();
        this.addRepositoryProxyPostProcessor((RepositoryProxyPostProcessor)this.crudMethodMetadataPostProcessor);
        this.entityViewReplacingMethodInterceptor = new EntityViewReplacingMethodInterceptor(entityManager, evm);
    }

    public void addRepositoryProxyPostProcessor(RepositoryProxyPostProcessor processor) {
        if (this.crudMethodMetadataPostProcessor != null) {
            Assert.notNull((Object)processor, (String)"RepositoryProxyPostProcessor must not be null!");
            super.addRepositoryProxyPostProcessor(processor);
            if (this.postProcessors == null) {
                this.postProcessors = new ArrayList<RepositoryProxyPostProcessor>();
            }
            this.postProcessors.add(processor);
        }
    }

    protected EntityViewAwareCrudMethodMetadata getCrudMethodMetadata() {
        return this.crudMethodMetadataPostProcessor == null ? null : this.crudMethodMetadataPostProcessor.getCrudMethodMetadata();
    }

    protected RepositoryMetadata getRepositoryMetadata(Class<?> repositoryInterface) {
        return new EntityViewAwareRepositoryMetadataImpl(super.getRepositoryMetadata(repositoryInterface), this.evm);
    }

    protected RepositoryInformation getRepositoryInformation(RepositoryMetadata metadata, Class<?> customImplementationClass) {
        return new EntityViewAwareRepositoryInformation((EntityViewAwareRepositoryMetadata)metadata, super.getRepositoryInformation(metadata, customImplementationClass));
    }

    protected void validate(RepositoryMetadata repositoryMetadata) {
        super.validate(repositoryMetadata);
        if (((EntityMetamodel)this.cbf.getService(EntityMetamodel.class)).getEntity(repositoryMetadata.getDomainType()) == null) {
            throw new InvalidDataAccessApiUsageException(String.format("Cannot implement repository %s when using a non-entity domain type %s. Only types annotated with @Entity are supported!", repositoryMetadata.getRepositoryInterface().getName(), repositoryMetadata.getDomainType().getName()));
        }
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        if (information instanceof EntityViewAwareRepositoryInformation && information.getRepositoryBaseClass() == EntityViewAwareRepositoryImpl.class) {
            JpaEntityInformation entityInformation = this.getEntityInformation(information.getDomainType());
            AbstractEntityViewAwareRepository entityViewAwareRepository = (AbstractEntityViewAwareRepository)this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.entityManager, this.cbf, this.evm, ((EntityViewAwareRepositoryInformation)information).getEntityViewType()});
            entityViewAwareRepository.setRepositoryMethodMetadata(this.getCrudMethodMetadata());
            return entityViewAwareRepository;
        }
        return super.getTargetRepository(information);
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        ExtendedManagedType managedType = (ExtendedManagedType)((EntityMetamodel)this.cbf.getService(EntityMetamodel.class)).getManagedType(ExtendedManagedType.class, metadata.getDomainType());
        if (managedType.getIdAttributes().size() == 1) {
            return EntityViewAwareRepositoryImpl.class;
        }
        return super.getRepositoryBaseClass(metadata);
    }

    public <T> T getRepository(Class<T> repositoryInterface, Object customImplementation) {
        if (this.postProcessors != null && this.postProcessors.get(this.postProcessors.size() - 1) != this.entityViewReplacingMethodInterceptor) {
            this.addRepositoryProxyPostProcessor((RepositoryProxyPostProcessor)this.entityViewReplacingMethodInterceptor);
        }
        return (T)super.getRepository(repositoryInterface, customImplementation);
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider) {
        switch (key != null ? key : QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND) {
            case CREATE: {
                return new CreateQueryLookupStrategy(this.entityManager, this.extractor, this.cbf, this.evm);
            }
            case USE_DECLARED_QUERY: {
                return new DelegateQueryLookupStrategy(super.getQueryLookupStrategy(key, evaluationContextProvider));
            }
            case CREATE_IF_NOT_FOUND: {
                return new CreateIfNotFoundQueryLookupStrategy(this.entityManager, this.extractor, new CreateQueryLookupStrategy(this.entityManager, this.extractor, this.cbf, this.evm), new DelegateQueryLookupStrategy(super.getQueryLookupStrategy(QueryLookupStrategy.Key.USE_DECLARED_QUERY, evaluationContextProvider)));
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported query lookup strategy %s!", key));
    }

    public List<QueryMethod> getQueryMethods() {
        return super.getQueryMethods();
    }

    private static class CreateQueryLookupStrategy
    implements QueryLookupStrategy {
        private final EntityManager em;
        private final QueryExtractor provider;
        private final PersistenceProvider persistenceProvider;
        private final CriteriaBuilderFactory cbf;
        private final EntityViewManager evm;

        public CreateQueryLookupStrategy(EntityManager em, QueryExtractor extractor, CriteriaBuilderFactory cbf, EntityViewManager evm) {
            this.em = em;
            this.provider = extractor;
            this.persistenceProvider = PersistenceProvider.fromEntityManager((EntityManager)em);
            this.cbf = cbf;
            this.evm = evm;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            try {
                return new PartTreeBlazePersistenceQuery(new EntityViewAwareJpaQueryMethod(method, (EntityViewAwareRepositoryMetadata)metadata, factory, this.provider), this.em, this.persistenceProvider, this.cbf, this.evm);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException(String.format("Could not create query metamodel for method %s!", method.toString()), e);
            }
        }
    }

    private static class DelegateQueryLookupStrategy
    implements QueryLookupStrategy {
        private final QueryLookupStrategy delegate;

        public DelegateQueryLookupStrategy(QueryLookupStrategy delegate) {
            this.delegate = delegate;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            return this.delegate.resolveQuery(method, metadata, factory, namedQueries);
        }
    }

    private static class CreateIfNotFoundQueryLookupStrategy
    implements QueryLookupStrategy {
        private final EntityManager em;
        private final QueryExtractor provider;
        private final DelegateQueryLookupStrategy lookupStrategy;
        private final CreateQueryLookupStrategy createStrategy;

        public CreateIfNotFoundQueryLookupStrategy(EntityManager em, QueryExtractor extractor, CreateQueryLookupStrategy createStrategy, DelegateQueryLookupStrategy lookupStrategy) {
            this.em = em;
            this.provider = extractor;
            this.createStrategy = createStrategy;
            this.lookupStrategy = lookupStrategy;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            try {
                return this.lookupStrategy.resolveQuery(method, metadata, factory, namedQueries);
            }
            catch (IllegalStateException e) {
                return this.createStrategy.resolveQuery(method, metadata, factory, namedQueries);
            }
        }
    }
}

