/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.impl.query;

import com.blazebit.persistence.spring.data.base.query.EntityViewAwareRepositoryMetadata;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import java.lang.reflect.Method;
import java.util.Set;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.util.TypeInformation;

public class EntityViewAwareRepositoryMetadataImpl
implements EntityViewAwareRepositoryMetadata {
    private final RepositoryMetadata metadata;
    private final EntityViewManager evm;
    private final Class<?> domainType;
    private final Class<?> entityViewType;

    public EntityViewAwareRepositoryMetadataImpl(RepositoryMetadata metadata, EntityViewManager evm) {
        this.metadata = metadata;
        this.evm = evm;
        Class domainType = metadata.getDomainType();
        ManagedViewType managedViewType = evm.getMetamodel().managedView(domainType);
        if (managedViewType == null) {
            this.domainType = domainType;
            this.entityViewType = null;
        } else {
            this.domainType = managedViewType.getEntityClass();
            this.entityViewType = managedViewType.getJavaType();
        }
    }

    public EntityViewManager getEntityViewManager() {
        return this.evm;
    }

    public Class<?> getIdType() {
        return this.metadata.getIdType();
    }

    public Class<?> getDomainType() {
        return this.domainType;
    }

    public Class<?> getEntityViewType() {
        return this.entityViewType;
    }

    public Class<?> getRepositoryInterface() {
        return this.metadata.getRepositoryInterface();
    }

    public Class<?> getReturnedDomainClass(Method method) {
        Class returnedDomainClass = this.metadata.getReturnedDomainClass(method);
        ManagedViewType managedViewType = this.evm.getMetamodel().managedView(returnedDomainClass);
        if (managedViewType == null) {
            return returnedDomainClass;
        }
        return managedViewType.getEntityClass();
    }

    public TypeInformation<?> getReturnType(Method method) {
        return this.metadata.getReturnType(method);
    }

    public Class<?> getReturnedEntityViewClass(Method method) {
        Class returnedDomainClass = this.metadata.getReturnedDomainClass(method);
        ManagedViewType managedViewType = this.evm.getMetamodel().managedView(returnedDomainClass);
        if (managedViewType == null) {
            return null;
        }
        return managedViewType.getJavaType();
    }

    public CrudMethods getCrudMethods() {
        return this.metadata.getCrudMethods();
    }

    public boolean isPagingRepository() {
        return this.metadata.isPagingRepository();
    }

    public Set<Class<?>> getAlternativeDomainTypes() {
        return this.metadata.getAlternativeDomainTypes();
    }

    public boolean isReactiveRepository() {
        return this.metadata.isReactiveRepository();
    }
}

