/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.impl.repository;

import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.spring.data.base.query.EntityViewAwareJpaQueryMethod;
import com.blazebit.persistence.spring.data.base.query.EntityViewAwareRepositoryMetadata;
import com.blazebit.persistence.spring.data.base.repository.AbstractEntityViewAwareRepository;
import com.blazebit.persistence.spring.data.base.repository.EntityViewAwareCrudMethodMetadata;
import com.blazebit.persistence.spring.data.base.repository.EntityViewAwareCrudMethodMetadataPostProcessor;
import com.blazebit.persistence.spring.data.impl.query.EntityViewAwareRepositoryInformation;
import com.blazebit.persistence.spring.data.impl.query.EntityViewAwareRepositoryMetadataImpl;
import com.blazebit.persistence.spring.data.impl.query.PartTreeBlazePersistenceQuery;
import com.blazebit.persistence.spring.data.impl.repository.DefaultRepositoryInformation;
import com.blazebit.persistence.spring.data.impl.repository.EntityViewAwareRepositoryImpl;
import com.blazebit.persistence.spring.data.impl.repository.MethodLookups;
import com.blazebit.persistence.spring.data.impl.repository.QueryCollectingQueryCreationListener;
import com.blazebit.persistence.spring.data.repository.EntityViewReplacingMethodInterceptor;
import com.blazebit.persistence.view.EntityViewManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.persistence.EntityManager;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.jpa.repository.support.JpaRepositoryImplementation;
import org.springframework.data.projection.DefaultMethodInvokingMethodInterceptor;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.MethodInvocationValidator;
import org.springframework.data.repository.core.support.PropertiesBasedNamedQueries;
import org.springframework.data.repository.core.support.QueryCreationListener;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.repository.core.support.RepositoryMethodInvocationListener;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.data.repository.core.support.SurroundingTransactionDetectorMethodInterceptor;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.repository.util.ReactiveWrappers;
import org.springframework.transaction.interceptor.TransactionalProxy;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public class BlazePersistenceRepositoryFactory
extends JpaRepositoryFactory {
    private static final Constructor<Advice> IMPLEMENTATION_METHOD_EXECUTION_INTERCEPTOR;
    private static final Constructor<Advice> QUERY_EXECUTOR_METHOD_INTERCEPTOR;
    private final EntityManager entityManager;
    private final CriteriaBuilderFactory cbf;
    private final EntityViewManager evm;
    private final QueryExtractor extractor;
    private final Map<RepositoryInformationCacheKey, RepositoryInformation> repositoryInformationCache;
    private final EntityViewReplacingMethodInterceptor entityViewReplacingMethodInterceptor;
    private List<RepositoryProxyPostProcessor> postProcessors;
    private EntityViewAwareCrudMethodMetadataPostProcessor crudMethodMetadataPostProcessor;
    private Optional<Class<?>> repositoryBaseClass;
    private QueryLookupStrategy.Key queryLookupStrategyKey;
    private List<QueryCreationListener<?>> queryPostProcessors;
    private List<RepositoryMethodInvocationListener> methodInvocationListeners;
    private NamedQueries namedQueries;
    private EscapeCharacter escapeCharacter = EscapeCharacter.DEFAULT;
    private ClassLoader classLoader;
    private QueryMethodEvaluationContextProvider evaluationContextProvider;
    private BeanFactory beanFactory;
    private final QueryCollectingQueryCreationListener collectingListener = new QueryCollectingQueryCreationListener();
    private static final BiFunction<Method, Object[], Object[]> REACTIVE_ARGS_CONVERTER;

    public BlazePersistenceRepositoryFactory(EntityManager entityManager, CriteriaBuilderFactory cbf, EntityViewManager evm) {
        super(entityManager);
        this.entityManager = entityManager;
        this.extractor = PersistenceProvider.fromEntityManager((EntityManager)entityManager);
        this.repositoryInformationCache = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.WEAK);
        this.cbf = cbf;
        this.evm = evm;
        this.namedQueries = PropertiesBasedNamedQueries.EMPTY;
        this.evaluationContextProvider = QueryMethodEvaluationContextProvider.DEFAULT;
        this.queryPostProcessors = new ArrayList();
        this.queryPostProcessors.add(this.collectingListener);
        this.methodInvocationListeners = new ArrayList<RepositoryMethodInvocationListener>();
        this.crudMethodMetadataPostProcessor = new EntityViewAwareCrudMethodMetadataPostProcessor();
        this.addRepositoryProxyPostProcessor((RepositoryProxyPostProcessor)this.crudMethodMetadataPostProcessor);
        this.repositoryBaseClass = Optional.empty();
        this.entityViewReplacingMethodInterceptor = new EntityViewReplacingMethodInterceptor(entityManager, evm);
    }

    public void setQueryLookupStrategyKey(QueryLookupStrategy.Key key) {
        this.queryLookupStrategyKey = key;
    }

    public void setNamedQueries(NamedQueries namedQueries) {
        this.namedQueries = namedQueries == null ? PropertiesBasedNamedQueries.EMPTY : namedQueries;
    }

    public void addQueryCreationListener(QueryCreationListener<?> listener) {
        Assert.notNull(listener, (String)"Listener must not be null!");
        this.queryPostProcessors.add(listener);
    }

    public void addInvocationListener(RepositoryMethodInvocationListener listener) {
        Assert.notNull((Object)listener, (String)"Listener must not be null!");
        this.methodInvocationListeners.add(listener);
    }

    public void addRepositoryProxyPostProcessor(RepositoryProxyPostProcessor processor) {
        if (this.crudMethodMetadataPostProcessor != null) {
            Assert.notNull((Object)processor, (String)"RepositoryProxyPostProcessor must not be null!");
            super.addRepositoryProxyPostProcessor(processor);
            if (this.postProcessors == null) {
                this.postProcessors = new ArrayList<RepositoryProxyPostProcessor>();
            }
            this.postProcessors.add(processor);
        }
    }

    protected List<QueryMethod> getQueryMethods() {
        return this.collectingListener.getQueryMethods();
    }

    public void setEscapeCharacter(EscapeCharacter escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    protected EntityViewAwareCrudMethodMetadata getCrudMethodMetadata() {
        return this.crudMethodMetadataPostProcessor == null ? null : this.crudMethodMetadataPostProcessor.getCrudMethodMetadata();
    }

    protected RepositoryMetadata getRepositoryMetadata(Class<?> repositoryInterface) {
        return new EntityViewAwareRepositoryMetadataImpl(super.getRepositoryMetadata(repositoryInterface), this.evm);
    }

    protected RepositoryInformation getRepositoryInformation(RepositoryMetadata metadata, RepositoryComposition.RepositoryFragments fragments) {
        return this.getRepositoryInformation(metadata, super.getRepositoryInformation(metadata, fragments));
    }

    protected RepositoryInformation getRepositoryInformation(RepositoryMetadata metadata, RepositoryInformation repositoryInformation) {
        return new EntityViewAwareRepositoryInformation((EntityViewAwareRepositoryMetadata)metadata, repositoryInformation);
    }

    protected void validate(RepositoryMetadata repositoryMetadata) {
        super.validate(repositoryMetadata);
        if (((EntityMetamodel)this.cbf.getService(EntityMetamodel.class)).getEntity(repositoryMetadata.getDomainType()) == null) {
            throw new InvalidDataAccessApiUsageException(String.format("Cannot implement repository %s when using a non-entity domain type %s. Only types annotated with @Entity are supported!", repositoryMetadata.getRepositoryInterface().getName(), repositoryMetadata.getDomainType().getName()));
        }
    }

    protected JpaRepositoryImplementation<?, ?> getTargetRepository(RepositoryInformation information, EntityManager entityManager) {
        JpaEntityInformation entityInformation = this.getEntityInformation(information.getDomainType());
        AbstractEntityViewAwareRepository entityViewAwareRepository = (AbstractEntityViewAwareRepository)this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, entityManager, this.cbf, this.evm, ((EntityViewAwareRepositoryInformation)information).getEntityViewType()});
        entityViewAwareRepository.setRepositoryMethodMetadata(this.getCrudMethodMetadata());
        return (JpaRepositoryImplementation)entityViewAwareRepository;
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return EntityViewAwareRepositoryImpl.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        switch (key != null ? key : QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND) {
            case CREATE: {
                return Optional.of(new CreateQueryLookupStrategy(this.entityManager, this.extractor, this.escapeCharacter, this.cbf, this.evm));
            }
            case USE_DECLARED_QUERY: {
                return Optional.of(new DelegateQueryLookupStrategy((QueryLookupStrategy)super.getQueryLookupStrategy(key, evaluationContextProvider).get()));
            }
            case CREATE_IF_NOT_FOUND: {
                return Optional.of(new CreateIfNotFoundQueryLookupStrategy(this.entityManager, this.extractor, new CreateQueryLookupStrategy(this.entityManager, this.extractor, this.escapeCharacter, this.cbf, this.evm), new DelegateQueryLookupStrategy((QueryLookupStrategy)super.getQueryLookupStrategy(QueryLookupStrategy.Key.USE_DECLARED_QUERY, evaluationContextProvider).get())));
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported query lookup strategy %s!", key));
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        super.setBeanClassLoader(classLoader);
        this.classLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setBeanFactory(beanFactory);
        this.beanFactory = beanFactory;
    }

    public void setRepositoryBaseClass(Class<?> repositoryBaseClass) {
        super.setRepositoryBaseClass(repositoryBaseClass);
        this.repositoryBaseClass = Optional.ofNullable(repositoryBaseClass);
    }

    public <T> T getRepository(Class<T> repositoryInterface, RepositoryComposition.RepositoryFragments fragments) {
        Assert.notNull(repositoryInterface, (String)"Repository interface must not be null!");
        Assert.notNull((Object)fragments, (String)"RepositoryFragments must not be null!");
        RepositoryMetadata metadata = this.getRepositoryMetadata(repositoryInterface);
        RepositoryComposition composition = this.getRepositoryComposition(metadata, fragments);
        RepositoryInformation information = this.getRepositoryInformation(metadata, composition);
        this.validate(information, composition);
        JpaRepositoryImplementation target = this.getTargetRepository(information);
        ProxyFactory result = new ProxyFactory();
        result.setTarget((Object)target);
        result.setInterfaces(new Class[]{repositoryInterface, Repository.class, TransactionalProxy.class});
        if (MethodInvocationValidator.supports(repositoryInterface)) {
            result.addAdvice((Advice)new MethodInvocationValidator());
        }
        result.addAdvice((Advice)SurroundingTransactionDetectorMethodInterceptor.INSTANCE);
        result.addAdvisor(ExposeInvocationInterceptor.ADVISOR);
        this.postProcessors.forEach(processor -> processor.postProcess(result, information));
        result.addAdvice((Advice)this.entityViewReplacingMethodInterceptor);
        result.addAdvice((Advice)new DefaultMethodInvokingMethodInterceptor());
        ProjectionFactory projectionFactory = this.getProjectionFactory(this.classLoader, this.beanFactory);
        Optional<QueryLookupStrategy> queryLookupStrategy = this.getQueryLookupStrategy(this.queryLookupStrategyKey, this.evaluationContextProvider);
        result.addAdvice(this.queryExecutorMethodInterceptor(information, projectionFactory, queryLookupStrategy, this.namedQueries, this.queryPostProcessors, this.methodInvocationListeners));
        composition = composition.append(RepositoryFragment.implemented((Object)target));
        result.addAdvice(this.implementationMethodExecutionInterceptor(information, composition, this.methodInvocationListeners));
        return (T)result.getProxy(this.classLoader);
    }

    private Advice implementationMethodExecutionInterceptor(RepositoryInformation information, RepositoryComposition composition, List<RepositoryMethodInvocationListener> methodInvocationListeners) {
        try {
            return IMPLEMENTATION_METHOD_EXECUTION_INTERCEPTOR.newInstance(information, composition, methodInvocationListeners);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Advice queryExecutorMethodInterceptor(RepositoryInformation repositoryInformation, ProjectionFactory projectionFactory, Optional<QueryLookupStrategy> queryLookupStrategy, NamedQueries namedQueries, List<QueryCreationListener<?>> queryPostProcessors, List<RepositoryMethodInvocationListener> methodInvocationListeners) {
        try {
            return QUERY_EXECUTOR_METHOD_INTERCEPTOR.newInstance(repositoryInformation, projectionFactory, queryLookupStrategy, namedQueries, queryPostProcessors, methodInvocationListeners);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void validate(RepositoryInformation repositoryInformation, RepositoryComposition composition) {
        if (repositoryInformation.hasCustomMethod()) {
            if (composition.isEmpty()) {
                throw new IllegalArgumentException(String.format("You have custom methods in %s but not provided a custom implementation!", repositoryInformation.getRepositoryInterface()));
            }
            composition.validateImplementation();
        }
        this.validate((RepositoryMetadata)repositoryInformation);
    }

    private RepositoryInformation getRepositoryInformation(RepositoryMetadata metadata, RepositoryComposition composition) {
        RepositoryInformationCacheKey cacheKey = new RepositoryInformationCacheKey(metadata, composition);
        return this.repositoryInformationCache.computeIfAbsent(cacheKey, key -> {
            Class<?> baseClass = this.repositoryBaseClass.orElse(this.getRepositoryBaseClass(metadata));
            return this.getRepositoryInformation(metadata, new DefaultRepositoryInformation(metadata, baseClass, composition));
        });
    }

    private RepositoryComposition getRepositoryComposition(RepositoryMetadata metadata, RepositoryComposition.RepositoryFragments fragments) {
        Assert.notNull((Object)metadata, (String)"RepositoryMetadata must not be null!");
        Assert.notNull((Object)fragments, (String)"RepositoryFragments must not be null!");
        RepositoryComposition composition = this.getRepositoryComposition(metadata);
        RepositoryComposition.RepositoryFragments repositoryAspects = this.getRepositoryFragments(metadata);
        return composition.append(fragments).append(repositoryAspects);
    }

    private RepositoryComposition getRepositoryComposition(RepositoryMetadata metadata) {
        RepositoryComposition composition = RepositoryComposition.empty();
        if (metadata.isReactiveRepository()) {
            return composition.withMethodLookup(MethodLookups.forReactiveTypes(metadata)).withArgumentConverter(REACTIVE_ARGS_CONVERTER);
        }
        return composition.withMethodLookup(MethodLookups.forRepositoryTypes(metadata));
    }

    static {
        Constructor<?> queryExecutorMethodInterceptor;
        Constructor<?> implementationMethodExecutionInterceptor;
        try {
            implementationMethodExecutionInterceptor = Class.forName("org.springframework.data.repository.core.support.RepositoryFactorySupport$ImplementationMethodExecutionInterceptor").getConstructor(RepositoryInformation.class, RepositoryComposition.class, List.class);
            implementationMethodExecutionInterceptor.setAccessible(true);
            queryExecutorMethodInterceptor = Class.forName("org.springframework.data.repository.core.support.QueryExecutorMethodInterceptor").getConstructor(RepositoryInformation.class, ProjectionFactory.class, Optional.class, NamedQueries.class, List.class, List.class);
            queryExecutorMethodInterceptor.setAccessible(true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        IMPLEMENTATION_METHOD_EXECUTION_INTERCEPTOR = implementationMethodExecutionInterceptor;
        QUERY_EXECUTOR_METHOD_INTERCEPTOR = queryExecutorMethodInterceptor;
        REACTIVE_ARGS_CONVERTER = (method, o) -> {
            if (ReactiveWrappers.isAvailable()) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                Object[] converted = new Object[((Object[])o).length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> parameterType = parameterTypes[i];
                    Object value = o[i];
                    if (value == null) continue;
                    converted[i] = !parameterType.isAssignableFrom(value.getClass()) && ReactiveWrapperConverters.canConvert(value.getClass(), parameterType) ? ReactiveWrapperConverters.toWrapper((Object)value, parameterType) : value;
                }
                return converted;
            }
            return o;
        };
    }

    private static class CreateQueryLookupStrategy
    implements QueryLookupStrategy {
        private final EntityManager em;
        private final QueryExtractor provider;
        private final PersistenceProvider persistenceProvider;
        private final EscapeCharacter escapeCharacter;
        private final CriteriaBuilderFactory cbf;
        private final EntityViewManager evm;

        public CreateQueryLookupStrategy(EntityManager em, QueryExtractor extractor, EscapeCharacter escapeCharacter, CriteriaBuilderFactory cbf, EntityViewManager evm) {
            this.em = em;
            this.provider = extractor;
            this.persistenceProvider = PersistenceProvider.fromEntityManager((EntityManager)em);
            this.escapeCharacter = escapeCharacter;
            this.cbf = cbf;
            this.evm = evm;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            try {
                return new PartTreeBlazePersistenceQuery(new EntityViewAwareJpaQueryMethod(method, (EntityViewAwareRepositoryMetadata)metadata, factory, this.provider), this.em, this.persistenceProvider, this.escapeCharacter, this.cbf, this.evm);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException(String.format("Could not create query metamodel for method %s!", method.toString()), e);
            }
        }
    }

    private static class DelegateQueryLookupStrategy
    implements QueryLookupStrategy {
        private final QueryLookupStrategy delegate;

        public DelegateQueryLookupStrategy(QueryLookupStrategy delegate) {
            this.delegate = delegate;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            return this.delegate.resolveQuery(method, metadata, factory, namedQueries);
        }
    }

    private static class CreateIfNotFoundQueryLookupStrategy
    implements QueryLookupStrategy {
        private final EntityManager em;
        private final QueryExtractor provider;
        private final DelegateQueryLookupStrategy lookupStrategy;
        private final CreateQueryLookupStrategy createStrategy;

        public CreateIfNotFoundQueryLookupStrategy(EntityManager em, QueryExtractor extractor, CreateQueryLookupStrategy createStrategy, DelegateQueryLookupStrategy lookupStrategy) {
            this.em = em;
            this.provider = extractor;
            this.createStrategy = createStrategy;
            this.lookupStrategy = lookupStrategy;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            try {
                return this.lookupStrategy.resolveQuery(method, metadata, factory, namedQueries);
            }
            catch (IllegalStateException e) {
                return this.createStrategy.resolveQuery(method, metadata, factory, namedQueries);
            }
        }
    }

    private static class RepositoryInformationCacheKey {
        String repositoryInterfaceName;
        final long compositionHash;

        public RepositoryInformationCacheKey(RepositoryMetadata metadata, RepositoryComposition composition) {
            this.repositoryInterfaceName = metadata.getRepositoryInterface().getName();
            this.compositionHash = composition.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RepositoryInformationCacheKey)) {
                return false;
            }
            RepositoryInformationCacheKey that = (RepositoryInformationCacheKey)o;
            if (this.compositionHash != that.compositionHash) {
                return false;
            }
            return this.repositoryInterfaceName != null ? this.repositoryInterfaceName.equals(that.repositoryInterfaceName) : that.repositoryInterfaceName == null;
        }

        public int hashCode() {
            int result = this.repositoryInterfaceName != null ? this.repositoryInterfaceName.hashCode() : 0;
            result = 31 * result + (int)(this.compositionHash ^ this.compositionHash >>> 32);
            return result;
        }
    }
}

