/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.impl.query;

import com.blazebit.persistence.spring.data.base.query.ParameterMetadataProvider;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.ParameterExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.expression.Expression;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

class ParameterMetadataProviderImpl
implements ParameterMetadataProvider {
    private final CriteriaBuilder builder;
    private final Iterator<? extends Parameter> parameters;
    private final List<ParameterMetadataProvider.ParameterMetadata<?>> expressions;
    private final Iterator<Object> bindableParameterValues;
    private final PersistenceProvider persistenceProvider;
    private final EscapeCharacter escape;

    public ParameterMetadataProviderImpl(CriteriaBuilder builder, ParametersParameterAccessor accessor, PersistenceProvider provider, EscapeCharacter escape) {
        this(builder, (Iterator<Object>)accessor.iterator(), accessor.getParameters(), provider, escape);
    }

    public ParameterMetadataProviderImpl(CriteriaBuilder builder, Parameters<?, ?> parameters, PersistenceProvider provider, EscapeCharacter escape) {
        this(builder, null, parameters, provider, escape);
    }

    private ParameterMetadataProviderImpl(CriteriaBuilder builder, Iterator<Object> bindableParameterValues, Parameters<?, ?> parameters, PersistenceProvider provider, EscapeCharacter escape) {
        Assert.notNull((Object)builder, (String)"CriteriaBuilder must not be null!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        Assert.notNull((Object)provider, (String)"PesistenceProvider must not be null!");
        this.builder = builder;
        this.parameters = parameters.getBindableParameters().iterator();
        this.expressions = new ArrayList();
        this.bindableParameterValues = bindableParameterValues;
        this.persistenceProvider = provider;
        this.escape = escape;
    }

    public List<ParameterMetadataProvider.ParameterMetadata<?>> getExpressions() {
        return this.expressions;
    }

    public <T> ParameterMetadataProvider.ParameterMetadata<T> next(Part part) {
        if (!this.parameters.hasNext()) {
            throw new IllegalArgumentException(String.format("No parameter available for part %s.", part));
        }
        Parameter parameter = this.parameters.next();
        return this.next(part, parameter.getType(), parameter);
    }

    public <T> ParameterMetadataProvider.ParameterMetadata<? extends T> next(Part part, Class<T> type) {
        Parameter parameter = this.parameters.next();
        Class typeToUse = ClassUtils.isAssignable(type, (Class)parameter.getType()) ? parameter.getType() : type;
        return this.next(part, typeToUse, parameter);
    }

    private <T> ParameterMetadataProvider.ParameterMetadata<T> next(Part part, Class<T> type, Parameter parameter) {
        Assert.notNull(type, (String)"Type must not be null!");
        Class reifiedType = Expression.class.equals(type) ? Object.class : type;
        Supplier<String> name = () -> (String)parameter.getName().orElseThrow(() -> new IllegalArgumentException("o_O Parameter needs to be named"));
        ParameterExpression expression = parameter.isExplicitlyNamed() ? this.builder.parameter(reifiedType, name.get()) : this.builder.parameter(reifiedType);
        Object value = this.bindableParameterValues == null ? ParameterMetadataProvider.ParameterMetadata.PLACEHOLDER : this.bindableParameterValues.next();
        ParameterMetadataImpl metadata = new ParameterMetadataImpl(expression, part, value, this.persistenceProvider, this.escape);
        this.expressions.add(metadata);
        return metadata;
    }

    EscapeCharacter getEscape() {
        return this.escape;
    }

    static class ParameterMetadataImpl<T>
    implements ParameterMetadataProvider.ParameterMetadata<T> {
        private final Part.Type type;
        private final ParameterExpression<T> expression;
        private final PersistenceProvider persistenceProvider;
        private final EscapeCharacter escape;
        private final boolean ignoreCase;

        public ParameterMetadataImpl(ParameterExpression<T> expression, Part part, Object value, PersistenceProvider provider, EscapeCharacter escape) {
            this.expression = expression;
            this.persistenceProvider = provider;
            this.type = value == null && Part.Type.SIMPLE_PROPERTY.equals((Object)part.getType()) ? Part.Type.IS_NULL : part.getType();
            this.ignoreCase = Part.IgnoreCaseType.ALWAYS.equals((Object)part.shouldIgnoreCase());
            this.escape = escape;
        }

        public ParameterExpression<T> getExpression() {
            return this.expression;
        }

        public boolean isIsNullParameter() {
            return Part.Type.IS_NULL.equals((Object)this.type);
        }

        public Object prepare(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            Class expressionType = this.expression.getJavaType();
            if (String.class.equals((Object)expressionType)) {
                switch (this.type) {
                    case STARTING_WITH: {
                        return String.format("%s%%", this.escape.escape(value.toString()));
                    }
                    case ENDING_WITH: {
                        return String.format("%%%s", this.escape.escape(value.toString()));
                    }
                    case CONTAINING: 
                    case NOT_CONTAINING: {
                        return String.format("%%%s%%", this.escape.escape(value.toString()));
                    }
                }
                return value;
            }
            return Collection.class.isAssignableFrom(expressionType) ? ParameterMetadataImpl.upperIfIgnoreCase(this.ignoreCase, ParameterMetadataImpl.toCollection(value)) : value;
        }

        private static Collection<?> toCollection(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Collection) {
                return (Collection)value;
            }
            if (ObjectUtils.isArray((Object)value)) {
                return Arrays.asList(ObjectUtils.toObjectArray((Object)value));
            }
            return Collections.singleton(value);
        }

        private static Collection<?> upperIfIgnoreCase(boolean ignoreCase, Collection<?> collection) {
            if (!ignoreCase || CollectionUtils.isEmpty(collection)) {
                return collection;
            }
            return collection.stream().map(it -> it == null ? null : it.toUpperCase()).collect(Collectors.toList());
        }
    }
}

