/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.impl.query;

import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.PagedList;
import com.blazebit.persistence.spring.data.base.query.AbstractPartTreeBlazePersistenceQuery;
import com.blazebit.persistence.spring.data.base.query.EntityViewAwareJpaQueryMethod;
import com.blazebit.persistence.spring.data.base.query.JpaParameters;
import com.blazebit.persistence.spring.data.base.query.KeysetAwarePageImpl;
import com.blazebit.persistence.spring.data.base.query.KeysetAwareSliceImpl;
import com.blazebit.persistence.spring.data.base.query.ParameterBinder;
import com.blazebit.persistence.spring.data.base.query.ParameterMetadataProvider;
import com.blazebit.persistence.spring.data.impl.query.CriteriaQueryParameterBinder;
import com.blazebit.persistence.spring.data.impl.query.ParameterMetadataProviderImpl;
import com.blazebit.persistence.spring.data.repository.KeysetPageable;
import com.blazebit.persistence.view.EntityViewManager;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.Jpa21Utils;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpaQueryExecution;
import org.springframework.data.jpa.repository.support.QueryHints;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeBlazePersistenceQuery
extends AbstractPartTreeBlazePersistenceQuery {
    public PartTreeBlazePersistenceQuery(EntityViewAwareJpaQueryMethod method, EntityManager em, PersistenceProvider persistenceProvider, EscapeCharacter escape, CriteriaBuilderFactory cbf, EntityViewManager evm) {
        super(method, em, persistenceProvider, (Object)escape, cbf, evm);
    }

    protected ParameterMetadataProvider createParameterMetadataProvider(CriteriaBuilder builder, ParametersParameterAccessor accessor, PersistenceProvider provider, Object escape) {
        return new ParameterMetadataProviderImpl(builder, accessor, provider, (EscapeCharacter)escape);
    }

    protected ParameterMetadataProvider createParameterMetadataProvider(CriteriaBuilder builder, JpaParameters parameters, PersistenceProvider provider, Object escape) {
        return new ParameterMetadataProviderImpl(builder, (Parameters<?, ?>)parameters, provider, (EscapeCharacter)escape);
    }

    protected JpaQueryExecution getExecution() {
        if (this.getQueryMethod().isSliceQuery()) {
            return new SlicedExecution((Parameters<?, ?>)this.getQueryMethod().getParameters());
        }
        if (this.getQueryMethod().isPageQuery()) {
            return new PagedExecution((Parameters<?, ?>)this.getQueryMethod().getParameters());
        }
        if (this.isDelete()) {
            return new DeleteExecution(this.getEntityManager());
        }
        if (this.isExists()) {
            return new ExistsExecution();
        }
        return super.getExecution();
    }

    protected Query doCreateQuery(JpaParametersParameterAccessor jpaParametersParameterAccessor) {
        return super.doCreateQuery(jpaParametersParameterAccessor.getValues());
    }

    protected Query doCreateCountQuery(JpaParametersParameterAccessor jpaParametersParameterAccessor) {
        return super.doCreateCountQuery(jpaParametersParameterAccessor.getValues());
    }

    protected boolean isCountProjection(PartTree tree) {
        return tree.isCountProjection();
    }

    protected boolean isDelete(PartTree tree) {
        return tree.isDelete();
    }

    protected boolean isExists(PartTree tree) {
        return tree.isExistsProjection();
    }

    protected int getOffset(Pageable pageable) {
        if (pageable.isPaged()) {
            if (pageable instanceof KeysetPageable) {
                return ((KeysetPageable)pageable).getIntOffset();
            }
            return (int)pageable.getOffset();
        }
        return 0;
    }

    protected int getLimit(Pageable pageable) {
        if (pageable.isPaged()) {
            return pageable.getPageSize();
        }
        return Integer.MAX_VALUE;
    }

    protected ParameterBinder createCriteriaQueryParameterBinder(JpaParameters parameters, Object[] values, List<ParameterMetadataProvider.ParameterMetadata<?>> expressions) {
        return new CriteriaQueryParameterBinder(this.getEntityManager(), this.evm, parameters, values, expressions);
    }

    protected Map<String, Object> tryGetFetchGraphHints(JpaEntityGraph entityGraph, Class<?> entityType) {
        QueryHints fetchGraphHint = Jpa21Utils.getFetchGraphHint((EntityManager)this.getEntityManager(), (JpaEntityGraph)entityGraph, (Class)this.getQueryMethod().getEntityInformation().getJavaType());
        HashMap<String, Object> map = new HashMap<String, Object>();
        fetchGraphHint.forEach(map::put);
        return map;
    }

    private static class SlicedExecution
    extends JpaQueryExecution {
        private final Parameters<?, ?> parameters;

        public SlicedExecution(Parameters<?, ?> parameters) {
            this.parameters = parameters;
        }

        protected Object doExecute(AbstractJpaQuery repositoryQuery, JpaParametersParameterAccessor jpaParametersParameterAccessor) {
            Query paginatedCriteriaBuilder = ((PartTreeBlazePersistenceQuery)repositoryQuery).createPaginatedQuery(jpaParametersParameterAccessor.getValues(), false);
            PagedList resultList = (PagedList)paginatedCriteriaBuilder.getResultList();
            ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.parameters, jpaParametersParameterAccessor.getValues());
            Pageable pageable = accessor.getPageable();
            return new KeysetAwareSliceImpl(resultList, pageable);
        }
    }

    private static class PagedExecution
    extends JpaQueryExecution {
        private final Parameters<?, ?> parameters;

        public PagedExecution(Parameters<?, ?> parameters) {
            this.parameters = parameters;
        }

        protected Object doExecute(AbstractJpaQuery repositoryQuery, JpaParametersParameterAccessor jpaParametersParameterAccessor) {
            Query paginatedCriteriaBuilder = ((PartTreeBlazePersistenceQuery)repositoryQuery).createPaginatedQuery(jpaParametersParameterAccessor.getValues(), true);
            PagedList resultList = (PagedList)paginatedCriteriaBuilder.getResultList();
            Long total = resultList.getTotalSize();
            ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.parameters, jpaParametersParameterAccessor.getValues());
            Pageable pageable = accessor.getPageable();
            if (total.equals(0L)) {
                return new KeysetAwarePageImpl(Collections.emptyList(), total.longValue(), null, pageable);
            }
            return new KeysetAwarePageImpl(resultList, pageable);
        }
    }

    static class DeleteExecution
    extends JpaQueryExecution {
        private final EntityManager em;

        public DeleteExecution(EntityManager em) {
            this.em = em;
        }

        protected Object doExecute(AbstractJpaQuery jpaQuery, JpaParametersParameterAccessor jpaParametersParameterAccessor) {
            Query query = ((PartTreeBlazePersistenceQuery)jpaQuery).createQuery(jpaParametersParameterAccessor);
            List resultList = query.getResultList();
            for (Object o : resultList) {
                this.em.remove(o);
            }
            return jpaQuery.getQueryMethod().isCollectionQuery() ? resultList : Integer.valueOf(resultList.size());
        }
    }

    private static class ExistsExecution
    extends JpaQueryExecution {
        private ExistsExecution() {
        }

        protected Object doExecute(AbstractJpaQuery repositoryQuery, JpaParametersParameterAccessor jpaParametersParameterAccessor) {
            return !((PartTreeBlazePersistenceQuery)repositoryQuery).createQuery(jpaParametersParameterAccessor).getResultList().isEmpty();
        }
    }
}

