/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.impl.repository;

import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.spring.data.base.repository.AbstractEntityViewAwareRepository;
import com.blazebit.persistence.spring.data.repository.EntityViewRepository;
import com.blazebit.persistence.spring.data.repository.KeysetPageable;
import com.blazebit.persistence.view.EntityViewManager;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.query.Jpa21Utils;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.data.jpa.repository.support.CrudMethodMetadata;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaRepositoryImplementation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class EntityViewAwareRepositoryImpl<V, E, ID extends Serializable>
extends AbstractEntityViewAwareRepository<E, E, ID>
implements JpaRepositoryImplementation<E, ID>,
EntityViewRepository<E, ID> {
    public EntityViewAwareRepositoryImpl(JpaEntityInformation<E, ?> entityInformation, EntityManager entityManager, CriteriaBuilderFactory cbf, EntityViewManager evm, Class<V> entityViewClass) {
        super(entityInformation, entityManager, cbf, evm, entityViewClass);
    }

    protected Map<String, Object> tryGetFetchGraphHints(EntityManager entityManager, JpaEntityGraph entityGraph, Class<?> entityType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Jpa21Utils.getFetchGraphHint((EntityManager)entityManager, (JpaEntityGraph)entityGraph, entityType).forEach(map::put);
        return map;
    }

    public <S extends E> Optional<S> findOne(Example<S> example) {
        try {
            return Optional.of(this.getQuery((Specification)new AbstractEntityViewAwareRepository.ExampleSpecification(example, this.escapeCharacter), example.getProbeType(), null).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<E> findOne(Specification<E> spec) {
        try {
            return Optional.of(this.getQuery(spec, null).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<E> findById(ID id) {
        return Optional.ofNullable(this.findOne((Serializable)id));
    }

    public E getById(ID id) {
        return (E)this.getReference((Serializable)id);
    }

    public void setRepositoryMethodMetadata(CrudMethodMetadata crudMethodMetadata) {
    }

    protected int getOffset(Pageable pageable) {
        if (pageable instanceof KeysetPageable) {
            return ((KeysetPageable)pageable).getIntOffset();
        }
        return (int)pageable.getOffset();
    }

    public <S extends E> long count(Example<S> example) {
        return super.count(example);
    }

    public <S extends E> boolean exists(Example<S> example) {
        return super.exists(example);
    }
}

