/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.base.query;

import com.blazebit.persistence.spring.data.base.query.EntityViewAwareRepositoryMetadata;
import com.blazebit.persistence.spring.data.base.query.JpaParameters;
import jakarta.persistence.LockModeType;
import jakarta.persistence.QueryHint;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;

public class EntityViewAwareJpaQueryMethod
extends JpaQueryMethod {
    private final Class<?> entityViewClass;
    private final JpaParameters parameters;
    private final LockModeType lockModeType;
    private final JpaEntityGraph entityGraph;
    private final Map<String, String> queryHints;

    public EntityViewAwareJpaQueryMethod(Method method, EntityViewAwareRepositoryMetadata metadata, ProjectionFactory factory, QueryExtractor extractor) {
        super(method, (RepositoryMetadata)metadata, factory, extractor);
        this.lockModeType = this.findLockModeType(method);
        this.entityGraph = this.findEntityGraph(method);
        this.queryHints = this.findQueryHints(method);
        this.entityViewClass = metadata.getReturnedEntityViewClass(method);
        this.parameters = new JpaParameters(method);
    }

    public LockModeType getLockModeType() {
        return this.lockModeType;
    }

    public JpaEntityGraph getEntityGraph() {
        return this.entityGraph;
    }

    public Map<String, String> getHints() {
        return this.queryHints;
    }

    public boolean isEntityViewQuery() {
        return this.entityViewClass != null;
    }

    public Class<?> getEntityViewClass() {
        return this.entityViewClass;
    }

    public JpaParameters getJpaParameters() {
        return this.parameters;
    }

    private JpaEntityGraph findEntityGraph(Method method) {
        EntityGraph entityGraph = (EntityGraph)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, EntityGraph.class);
        return entityGraph == null ? null : new JpaEntityGraph(entityGraph, this.getNamedQueryName());
    }

    private LockModeType findLockModeType(Method method) {
        Lock annotation = (Lock)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Lock.class);
        return annotation == null ? null : (LockModeType)AnnotationUtils.getValue((Annotation)annotation);
    }

    private Map<String, String> findQueryHints(Method method) {
        QueryHint queryHintAnnotation;
        HashMap<String, String> queryHints = new HashMap<String, String>();
        QueryHints queryHintsAnnotation = (QueryHints)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, QueryHints.class);
        if (queryHintsAnnotation != null) {
            for (QueryHint hint : queryHintsAnnotation.value()) {
                queryHints.put(hint.name(), hint.value());
            }
        }
        if ((queryHintAnnotation = (QueryHint)AnnotationUtils.findAnnotation((Method)method, QueryHint.class)) != null) {
            queryHints.put(queryHintAnnotation.name(), queryHintAnnotation.value());
        }
        return Collections.unmodifiableMap(queryHints);
    }
}

