/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.repository.config;

import com.blazebit.persistence.spring.data.repository.EntityViewRepository;
import com.blazebit.persistence.spring.data.repository.EntityViewSpecificationExecutor;
import com.blazebit.persistence.view.EntityView;
import jakarta.persistence.Entity;
import jakarta.persistence.MappedSuperclass;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.config.JpaRepositoryConfigExtension;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationSource;

public class BlazeRepositoryConfigExtension
extends JpaRepositoryConfigExtension {
    public String getModuleName() {
        return "Blaze-Persistence";
    }

    public String getRepositoryFactoryClassName() {
        return this.getRepositoryFactoryBeanClassName();
    }

    public String getRepositoryFactoryBeanClassName() {
        return "com.blazebit.persistence.spring.data.impl.repository.BlazePersistenceRepositoryFactoryBean";
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Arrays.asList(Entity.class, MappedSuperclass.class, EntityView.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Arrays.asList(JpaRepository.class, EntityViewRepository.class, EntityViewSpecificationExecutor.class);
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource config) {
        AnnotationAttributes attributes = ((AnnotationRepositoryConfigurationSource)config).getAttributes();
        if (attributes.get((Object)"repositoryFactoryBeanClass") == Void.TYPE) {
            try {
                attributes.put((Object)"repositoryFactoryBeanClass", Class.forName(this.getRepositoryFactoryBeanClassName()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        super.registerBeansForRoot(registry, config);
    }
}

