/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.base.repository;

import jakarta.persistence.Query;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;

public abstract class FluentQuerySupport<S, R> {
    protected final Class<R> resultType;
    protected final Sort sort;
    protected final int limit;
    protected final Set<String> properties;
    protected final Class<S> entityType;
    private final SpelAwareProxyProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory();

    public FluentQuerySupport(Class<R> resultType, Sort sort, int limit, Collection<String> properties, Class<S> entityType) {
        this.resultType = resultType;
        this.sort = sort;
        this.limit = limit;
        this.properties = properties != null ? new HashSet<String>(properties) : Collections.emptySet();
        this.entityType = entityType;
    }

    final Collection<String> mergeProperties(Collection<String> additionalProperties) {
        HashSet<String> newProperties = new HashSet<String>();
        newProperties.addAll(this.properties);
        newProperties.addAll(additionalProperties);
        return Collections.unmodifiableCollection(newProperties);
    }

    final Function<Object, R> getConversionFunction(Class<S> inputType, Class<R> targetType) {
        if (targetType.isAssignableFrom(inputType)) {
            return Function.identity();
        }
        if (targetType.isInterface()) {
            return o -> this.projectionFactory.createProjection(targetType, o);
        }
        return o -> DefaultConversionService.getSharedInstance().convert(o, targetType);
    }

    static interface ScrollQueryFactory {
        public Query createQuery(Sort var1, ScrollPosition var2);
    }
}

