/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.repository;

import com.blazebit.persistence.KeysetPage;
import com.blazebit.persistence.spring.data.repository.KeysetPageable;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class KeysetPageRequest
extends PageRequest
implements KeysetPageable {
    private final KeysetPage keysetPage;
    private final int offset;
    private final boolean withCountQuery;
    private final boolean withExtractAllKeysets;

    public KeysetPageRequest(int page, int pageSize, KeysetPage keysetPage, Sort sort) {
        this(keysetPage, sort, page * pageSize, pageSize);
    }

    public KeysetPageRequest(KeysetPage keysetPage, Pageable pageable) {
        this(keysetPage, pageable.getSort(), pageable.getPageNumber() * pageable.getPageSize(), pageable.getPageSize());
    }

    public KeysetPageRequest(KeysetPage keysetPage, Sort sort) {
        this(keysetPage, sort, keysetPage.getFirstResult(), keysetPage.getMaxResults());
    }

    public KeysetPageRequest(KeysetPage keysetPage, Sort sort, int offset, int pageSize) {
        this(keysetPage, sort, offset, pageSize, true, false);
    }

    public KeysetPageRequest(KeysetPage keysetPage, Sort sort, int offset, int pageSize, boolean withCountQuery, boolean withExtractAllKeysets) {
        super(offset / pageSize, pageSize, sort);
        this.keysetPage = keysetPage;
        this.offset = offset;
        this.withCountQuery = withCountQuery;
        this.withExtractAllKeysets = withExtractAllKeysets;
    }

    @Override
    public boolean isWithCountQuery() {
        return this.withCountQuery;
    }

    @Override
    public boolean isWithExtractAllKeysets() {
        return this.withExtractAllKeysets;
    }

    @Override
    public int getIntOffset() {
        return this.offset;
    }

    @Override
    public KeysetPage getKeysetPage() {
        return this.keysetPage;
    }

    public KeysetPageRequest next() {
        return new KeysetPageRequest(this.keysetPage, this.getSort(), this.getIntOffset() + this.getPageSize(), this.getPageSize(), this.isWithCountQuery(), this.isWithExtractAllKeysets());
    }

    public KeysetPageRequest previousOrFirst() {
        if (this.getIntOffset() == 0) {
            return this;
        }
        return new KeysetPageRequest(this.keysetPage, this.getSort(), this.getIntOffset() - this.getPageSize(), this.getPageSize(), this.isWithCountQuery(), this.isWithExtractAllKeysets());
    }

    public KeysetPageRequest first() {
        if (this.getIntOffset() == 0) {
            return this;
        }
        return new KeysetPageRequest(this.keysetPage, this.getSort(), 0, this.getPageSize(), this.isWithCountQuery(), this.isWithExtractAllKeysets());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeysetPageable)) {
            return false;
        }
        KeysetPageable that = (KeysetPageable)o;
        if (this.isWithCountQuery() != that.isWithCountQuery()) {
            return false;
        }
        if (this.isWithExtractAllKeysets() != that.isWithExtractAllKeysets()) {
            return false;
        }
        if (this.getIntOffset() != that.getIntOffset()) {
            return false;
        }
        if (this.getPageSize() != that.getPageSize()) {
            return false;
        }
        if (this.getKeysetPage() != null ? !this.getKeysetPage().equals(that.getKeysetPage()) : that.getKeysetPage() != null) {
            return false;
        }
        return this.getSort() != null ? this.getSort().equals((Object)that.getSort()) : that.getSort() == null;
    }

    public int hashCode() {
        int result = this.getKeysetPage() != null ? this.getKeysetPage().hashCode() : 0;
        result = 31 * result + (this.getSort() != null ? this.getSort().hashCode() : 0);
        result = 31 * result + (this.isWithCountQuery() ? 1 : 0);
        result = 31 * result + (this.isWithExtractAllKeysets() ? 1 : 0);
        result = 31 * result + this.getIntOffset();
        result = 31 * result + this.getPageSize();
        return result;
    }
}

