/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.base.query;

import com.blazebit.persistence.spring.data.base.query.JpaParameters;
import com.blazebit.persistence.spring.data.base.query.ParameterBinder;
import com.blazebit.persistence.spring.data.base.query.ParameterMetadataProvider;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import java.util.Date;
import java.util.Iterator;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.springframework.util.Assert;

public abstract class AbstractCriteriaQueryParameterBinder
extends ParameterBinder {
    private final EntityManager em;
    private final EntityViewManager evm;
    private final Iterator<ParameterMetadataProvider.ParameterMetadata<?>> expressions;

    public AbstractCriteriaQueryParameterBinder(EntityManager em, EntityViewManager evm, JpaParameters parameters, Object[] values, Iterable<ParameterMetadataProvider.ParameterMetadata<?>> expressions) {
        super(parameters, values);
        Assert.notNull(expressions, (String)"Iterable of ParameterMetadata must not be null!");
        this.em = em;
        this.evm = evm;
        this.expressions = expressions.iterator();
    }

    @Override
    protected void bind(Query query, JpaParameters.JpaParameter parameter, Object value, int position) {
        ParameterMetadataProvider.ParameterMetadata<?> metadata = this.expressions.next();
        if (metadata.isIsNullParameter()) {
            return;
        }
        Object paramValue = metadata.prepare(value);
        if (parameter.isTemporalParameter()) {
            if (metadata.getExpression().getPosition() == null) {
                if (metadata.getExpression().getName() == null) {
                    query.setParameter(metadata.getExpression(), (Date)paramValue, parameter.getTemporalType());
                } else {
                    query.setParameter(metadata.getExpression().getName(), (Date)paramValue, parameter.getTemporalType());
                }
            } else {
                query.setParameter(metadata.getExpression().getPosition().intValue(), (Date)paramValue, parameter.getTemporalType());
            }
        } else {
            if (paramValue instanceof EntityViewProxy) {
                paramValue = this.evm.getEntityReference(this.em, paramValue);
            }
            if (metadata.getExpression().getPosition() == null) {
                if (metadata.getExpression().getName() == null) {
                    query.setParameter(metadata.getExpression(), paramValue);
                } else {
                    query.setParameter(metadata.getExpression().getName(), paramValue);
                }
            } else {
                query.setParameter(metadata.getExpression().getPosition().intValue(), paramValue);
            }
        }
    }
}

